/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.nesscomputing.galaxy.GalaxyConfig;
import com.nesscomputing.galaxy.GalaxyIp;
import com.nesscomputing.httpserver.AbstractJetty8HttpServer;
import com.nesscomputing.httpserver.GalaxyHttpServerConfig;
import com.nesscomputing.httpserver.HttpConnector;
import com.nesscomputing.httpserver.HttpServer;
import com.nesscomputing.httpserver.HttpServerConfig;
import java.util.Map;
import javax.servlet.Servlet;

public class GalaxyJetty8HttpServer
extends AbstractJetty8HttpServer
implements HttpServer {
    private final Map<String, HttpConnector> httpConnectors;

    @Inject
    GalaxyJetty8HttpServer(GalaxyConfig galaxyConfig, GalaxyHttpServerConfig galaxyHttpServerConfig, HttpServerConfig httpServerConfig, @Named(value="_catchall") Servlet catchallServlet) {
        super(httpServerConfig, catchallServlet);
        this.httpConnectors = GalaxyJetty8HttpServer.buildConnectors(galaxyHttpServerConfig, galaxyConfig);
    }

    @Override
    public Map<String, HttpConnector> getConnectors() {
        return this.httpConnectors;
    }

    private static Map<String, HttpConnector> buildConnectors(GalaxyHttpServerConfig galaxyHttpServerConfig, GalaxyConfig galaxyConfig) {
        GalaxyIp internalIp = galaxyConfig.getInternalIp();
        GalaxyIp externalIp = galaxyConfig.getExternalIp();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (galaxyHttpServerConfig.isInternalHttpEnabled()) {
            builder.put((Object)"internal-http", (Object)new HttpConnector(false, "http", internalIp.getIp(), internalIp.getHttpPort()));
        }
        if (galaxyHttpServerConfig.isInternalHttpsEnabled()) {
            builder.put((Object)"internal-https", (Object)new HttpConnector(true, "https", internalIp.getIp(), internalIp.getHttpsPort()));
        }
        if (galaxyHttpServerConfig.isExternalHttpEnabled()) {
            builder.put((Object)"external-http", (Object)new HttpConnector(false, "http", externalIp.getIp(), internalIp.getHttpPort()));
        }
        if (galaxyHttpServerConfig.isExternalHttpsEnabled()) {
            builder.put((Object)"external-https", (Object)new HttpConnector(true, "https", externalIp.getIp(), internalIp.getHttpsPort()));
        }
        return builder.build();
    }
}

