/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.nesscomputing.httpserver.AbstractJetty8HttpServer;
import com.nesscomputing.httpserver.HttpConnector;
import com.nesscomputing.httpserver.HttpServer;
import com.nesscomputing.httpserver.HttpServerConfig;
import com.nesscomputing.httpserver.SoloHttpServerConfig;
import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;

public class SoloJetty8HttpServer
extends AbstractJetty8HttpServer
implements HttpServer {
    private final Map<String, HttpConnector> connectors;

    @Inject
    SoloJetty8HttpServer(SoloHttpServerConfig soloHttpServerConfig, HttpServerConfig httpServerConfig, @Named(value="_catchall") Servlet catchallServlet) {
        super(httpServerConfig, catchallServlet);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Object[] serviceUris = soloHttpServerConfig.getServiceUris();
        Preconditions.checkState((boolean)ArrayUtils.isNotEmpty((Object[])serviceUris), (Object)"at least one valid URI must be given!");
        int count = 0;
        for (Object serviceUri : serviceUris) {
            String scheme = ((URI)serviceUri).getScheme();
            boolean secure = "https".equals(scheme);
            int port = ((URI)serviceUri).getPort();
            if (port == 0) {
                port = secure ? 443 : 80;
            }
            builder.put((Object)(count == 0 ? "service" : String.format("service-%d", count)), (Object)new HttpConnector(secure, scheme, ((URI)serviceUri).getHost(), port));
            ++count;
        }
        this.connectors = builder.build();
    }

    @Override
    public Map<String, HttpConnector> getConnectors() {
        return this.connectors;
    }
}

