/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.log4j;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.HttpServerHandlerBinder;
import com.nesscomputing.httpserver.log.log4j.Log4jRequestLog;
import com.nesscomputing.httpserver.log.log4j.Log4jRequestLogConfig;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;

public class Log4jRequestLogModule
extends AbstractModule {
    private final Config config;

    public Log4jRequestLogModule(Config config) {
        this.config = config;
    }

    public void configure() {
        Log4jRequestLogConfig log4jRequestLogConfig = (Log4jRequestLogConfig)this.config.getBean("ness.httpserver.request-log.log4j", Log4jRequestLogConfig.class);
        if (log4jRequestLogConfig.isEnabled()) {
            this.bind(Log4jRequestLogConfig.class).toInstance((Object)log4jRequestLogConfig);
            this.bind(Log4jRequestLog.class).in(Scopes.SINGLETON);
            HttpServerHandlerBinder.bindLoggingHandler(this.binder()).toProvider(HandlerProvider.class);
        }
    }

    public static class HandlerProvider
    implements Provider<RequestLogHandler> {
        private final Log4jRequestLog log4jRequestLog;

        @Inject
        public HandlerProvider(Log4jRequestLog log4jRequestLog) {
            this.log4jRequestLog = log4jRequestLog;
        }

        public RequestLogHandler get() {
            RequestLogHandler handler = new RequestLogHandler();
            handler.setRequestLog((RequestLog)this.log4jRequestLog);
            return handler;
        }
    }
}

