/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.standalone;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.jmx.JmxModule;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleModule;
import com.nesscomputing.log.jmx.guice.JmxLoggingModule;
import com.nesscomputing.log4j.ConfigureStandaloneLogging;
import com.nesscomputing.logging.AssimilateForeignLogging;
import com.nesscomputing.logging.Log;
import org.apache.commons.lang3.time.StopWatch;

@Deprecated
public abstract class StandaloneServer {
    private static final Log LOG = Log.findLog();
    @Inject
    private final GuiceFilter guiceFilter = null;
    private final Thread shutdownThread = new Thread("Server Shutdown Thread"){

        @Override
        public void run() {
            LOG.info("Shutting Service down");
            StandaloneServer.this.doStopServer(true);
        }
    };
    @Inject
    private Lifecycle lifecycle;
    private boolean started = false;
    private boolean stopped = false;

    public StandaloneServer() {
        ConfigureStandaloneLogging.configure((String)this.getLoggingConfigurationName());
        AssimilateForeignLogging.assimilate();
    }

    public void startServer() {
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Server was already started, double-start denied!");
        StopWatch timer = new StopWatch();
        timer.start();
        Injector injector = this.getInjector();
        injector.injectMembers((Object)this);
        timer.stop();
        long injectorTime = timer.getTime();
        timer.reset();
        Preconditions.checkNotNull((Object)this.lifecycle, (Object)"No Lifecycle Object was injected!");
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        LOG.info("Starting Service");
        timer.start();
        this.lifecycle.executeTo(this.getStartStage());
        timer.stop();
        this.started = true;
        LOG.info("Service startup completed; %d ms in module initialization and %d ms to start lifecycle.", new Object[]{injectorTime, timer.getTime()});
    }

    public void stopServer() {
        this.doStopServer(false);
    }

    private final void doStopServer(boolean fromHook) {
        Preconditions.checkState((!this.stopped ? 1 : 0) != 0, (Object)"Server was already stopped, double-stop denied!");
        Preconditions.checkNotNull((Object)this.lifecycle, (Object)"No Lifecycle Object was injected!");
        LOG.info("Stopping Service");
        this.lifecycle.executeTo(this.getStopStage());
        if (!fromHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        }
        this.stopped = true;
        if (this.guiceFilter != null) {
            this.guiceFilter.destroy();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Module getPlumbingModules(final Config config) {
        return new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new ConfigModule(config));
                binder.install((Module)new JmxModule());
                binder.install((Module)new JmxLoggingModule("server"));
                binder.install(StandaloneServer.this.getLifecycleModule());
                binder.bind(GuiceFilter.class).in(Scopes.SINGLETON);
                binder.install((Module)new ServletModule());
            }
        };
    }

    public Config getConfig() {
        return Config.getConfig();
    }

    public final Injector getInjector() {
        Config config = this.getConfig();
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.getPlumbingModules(config), this.getMainModule(config), new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
            }
        }});
        return injector;
    }

    protected LifecycleStage getStartStage() {
        return LifecycleStage.START_STAGE;
    }

    protected LifecycleStage getStopStage() {
        return LifecycleStage.STOP_STAGE;
    }

    protected Module getLifecycleModule() {
        return new LifecycleModule();
    }

    protected abstract Module getMainModule(Config var1);

    protected String getLoggingConfigurationName() {
        return "standalone";
    }
}

