/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.testing;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class LocalHttpService {
    private final Server server = new Server();
    private final Connector connector;

    public static LocalHttpService forHandler(Handler handler) {
        return new LocalHttpService(handler, LocalHttpService.getHttpConnector());
    }

    public static LocalHttpService forSecureHandler(Handler handler, String login, String password) {
        return new LocalHttpService(LocalHttpService.getSecuredHandler(handler, login, password), LocalHttpService.getHttpConnector());
    }

    public static LocalHttpService forSSLHandler(Handler handler) {
        return new LocalHttpService(handler, LocalHttpService.getSSLHttpConnector());
    }

    public static LocalHttpService forSecureSSLHandler(Handler handler, String login, String password) {
        return new LocalHttpService(LocalHttpService.getSecuredHandler(handler, login, password), LocalHttpService.getSSLHttpConnector());
    }

    public static LocalHttpService forSSLClientSSLServerHandler(Handler handler, String truststore, String truststorePassword, String keystore, String keystorePassword, String keystoreType) {
        return new LocalHttpService(handler, LocalHttpService.getSSLClientCertHttpConnector(truststore, truststorePassword, keystore, keystorePassword, keystoreType));
    }

    private static Connector getHttpConnector() {
        SelectChannelConnector scc = new SelectChannelConnector();
        scc.setPort(0);
        scc.setHost("localhost");
        return scc;
    }

    private static Connector getSSLHttpConnector() {
        URL keystoreUrl = Resources.getResource(LocalHttpService.class, (String)"/ssl-server-keystore.jks");
        SslContextFactory contextFactory = new SslContextFactory();
        contextFactory.setKeyStorePath(keystoreUrl.toString());
        contextFactory.setKeyStorePassword("changeit");
        contextFactory.setKeyManagerPassword("changeit");
        SslSelectChannelConnector scc = new SslSelectChannelConnector(contextFactory);
        scc.setPort(0);
        scc.setHost("localhost");
        return scc;
    }

    private static Connector getSSLClientCertHttpConnector(String truststore, String truststorePassword, String keystore, String keystorePassword, String keystoreType) {
        URL keystoreUrl = Resources.getResource(LocalHttpService.class, (String)keystore);
        SslContextFactory contextFactory = new SslContextFactory();
        contextFactory.setKeyStorePath(keystoreUrl.toString());
        contextFactory.setKeyStorePassword(keystorePassword);
        contextFactory.setKeyManagerPassword(keystorePassword);
        contextFactory.setKeyStoreType(keystoreType);
        URL truststoreUrl = Resources.getResource(LocalHttpService.class, (String)truststore);
        contextFactory.setTrustStore(truststoreUrl.toString());
        contextFactory.setTrustStorePassword(truststorePassword);
        contextFactory.setTrustStoreType("JKS");
        contextFactory.setNeedClientAuth(true);
        SslSelectChannelConnector scc = new SslSelectChannelConnector(contextFactory);
        scc.setPort(0);
        scc.setHost("localhost");
        return scc;
    }

    private static Handler getSecuredHandler(Handler handler, String login, String password) {
        DummySecurityHandler securityHandler = new DummySecurityHandler(login);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setIdentityService((IdentityService)new DefaultIdentityService());
        securityHandler.setLoginService(new DummyLoginService(login, password));
        securityHandler.setHandler(handler);
        return securityHandler;
    }

    @Deprecated
    public LocalHttpService(Handler handler) {
        this(handler, LocalHttpService.getHttpConnector());
    }

    private LocalHttpService(Handler handler, Connector connector) {
        this.connector = connector;
        this.server.setConnectors(new Connector[]{connector});
        this.server.setHandler(handler);
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("LocalHttpService did not start properly!");
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("LocalHttpService did not stop properly!");
        }
        try {
            this.server.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getHost() {
        return this.connector.getHost();
    }

    public int getPort() {
        return this.connector.getLocalPort();
    }

    private static class DummyLoginService
    implements LoginService {
        private final String login;
        private final String password;
        private IdentityService identityService;

        private DummyLoginService(String login, String password) {
            this.login = login;
            this.password = password;
        }

        public String getName() {
            return "test";
        }

        public UserIdentity login(String username, Object credentials) {
            if (StringUtils.equals((CharSequence)this.login, (CharSequence)username) && StringUtils.equals((CharSequence)this.password, (CharSequence)String.valueOf(credentials))) {
                Password c = new Password(String.valueOf(credentials));
                MappedLoginService.KnownUser p = new MappedLoginService.KnownUser(username, (Credential)c);
                final Subject subject = new Subject();
                subject.getPrincipals().add((Principal)p);
                subject.getPrivateCredentials().add(c);
                return new UserIdentity((Principal)p){
                    final /* synthetic */ Principal val$p;
                    {
                        this.val$p = principal;
                    }

                    public Subject getSubject() {
                        return subject;
                    }

                    public Principal getUserPrincipal() {
                        return this.val$p;
                    }

                    public boolean isUserInRole(String role, UserIdentity.Scope scope) {
                        return true;
                    }
                };
            }
            return null;
        }

        public void logout(UserIdentity user) {
        }

        public boolean validate(UserIdentity user) {
            return false;
        }

        public IdentityService getIdentityService() {
            return this.identityService;
        }

        public void setIdentityService(IdentityService service) {
            this.identityService = service;
        }
    }

    private static class DummySecurityHandler
    extends SecurityHandler {
        private final String login;

        private DummySecurityHandler(String login) {
            this.login = login;
        }

        protected Object prepareConstraintInfo(String pathInContext, Request request) {
            return null;
        }

        protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, Object constraintInfo) throws IOException {
            return true;
        }

        protected boolean isAuthMandatory(Request baseRequest, Response base_response, Object constraintInfo) {
            return true;
        }

        protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) throws IOException {
            return userIdentity != null && StringUtils.equals((CharSequence)this.login, (CharSequence)userIdentity.getUserPrincipal().getName());
        }
    }
}

