/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.galaxy.GalaxyConfigModule;
import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientObserverGroup;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.guice.HttpClientModule;
import com.nesscomputing.httpclient.response.StringContentConverter;
import com.nesscomputing.httpserver.HttpServerHandlerBinder;
import com.nesscomputing.httpserver.HttpServerModule;
import com.nesscomputing.httpserver.jetty.ClasspathResourceHandler;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleModule;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:0"})
public class TestHttpServerForwardedHeaders {
    @Inject
    @Named(value="test")
    private final HttpClient httpClient = null;
    @Inject
    private final Lifecycle lifecycle = null;
    private String baseUri = null;
    private int port = 0;
    private RecordingHandlerWrapper handler = null;

    @Before
    public void setUp() throws Exception {
        this.port = TestHttpServerForwardedHeaders.findUnusedPort();
        Assert.assertFalse((this.port == 0 ? 1 : 0) != 0);
        this.baseUri = String.format("http://localhost:%d/foobar", this.port);
        Config config = Config.getFixedConfig((String[])new String[]{"galaxy.internal.port.http", Integer.toString(this.port), "ness.httpserver.forwarded", "true"});
        this.handler = new RecordingHandlerWrapper((AbstractHandler)new ClasspathResourceHandler("/foobar", "/test-resources"));
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigModule(config), new HttpServerModule(config), new HttpClientModule("test", new HttpClientObserverGroup[0]), new LifecycleModule(), new GalaxyConfigModule(), new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
                HttpServerHandlerBinder.bindHandler((Binder)binder).toInstance((Object)TestHttpServerForwardedHeaders.this.handler);
            }
        }});
        injector.injectMembers((Object)this);
        this.lifecycle.executeTo(LifecycleStage.START_STAGE);
    }

    @After
    public void teardown() {
        this.lifecycle.executeTo(LifecycleStage.STOP_STAGE);
    }

    @Test
    public void testSimpleGet() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).addHeader("X-Forwarded-For", "1.2.3.4").addHeader("X-Forwarded-Server", "www.likeness.com").addHeader("X-Forwarded-Proto", "https").perform();
        Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
        Assert.assertEquals((Object)"www.likeness.com", (Object)this.handler.getLocalAddr());
        Assert.assertEquals((long)443L, (long)this.handler.getLocalPort().intValue());
        Assert.assertEquals((Object)"1.2.3.4", (Object)this.handler.getRemoteAddr());
        Assert.assertTrue((boolean)this.handler.getSecure());
        Assert.assertEquals((Object)"https", (Object)this.handler.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findUnusedPort() throws IOException {
        int port;
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        return port;
    }

    public static class RecordingHandlerWrapper
    extends AbstractHandler {
        private final AbstractHandler wrappedHandler;
        private String localAddr = null;
        private Integer localPort = null;
        private String remoteAddr = null;
        private Integer remotePort = null;
        private Boolean secure = null;
        private String scheme = null;

        RecordingHandlerWrapper(AbstractHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.localAddr = request.getServerName();
            this.localPort = request.getServerPort();
            this.secure = request.isSecure();
            this.remoteAddr = request.getRemoteHost();
            this.remotePort = request.getRemotePort();
            this.scheme = request.getScheme();
            this.wrappedHandler.handle(target, baseRequest, request, response);
        }

        public String getLocalAddr() {
            return this.localAddr;
        }

        public Integer getLocalPort() {
            return this.localPort;
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public Integer getRemotePort() {
            return this.remotePort;
        }

        public Boolean getSecure() {
            return this.secure;
        }

        public String getScheme() {
            return this.scheme;
        }
    }
}

