/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.executable.externalcomm.io;

import com.nosolojava.fsm.impl.runtime.basic.BasicEvent;
import com.nosolojava.fsm.impl.runtime.basic.PlatformEvents;
import com.nosolojava.fsm.runtime.Context;
import com.nosolojava.fsm.runtime.Event;
import com.nosolojava.fsm.runtime.EventType;
import com.nosolojava.fsm.runtime.StateMachineEngine;
import com.nosolojava.fsm.runtime.executable.externalcomm.IOProcessor;
import com.nosolojava.fsm.runtime.executable.externalcomm.Message;
import java.net.URI;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScxmlIOProcessor
implements IOProcessor {
    Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String NAME = "scxml";
    public static final String _INTERNAL = "_internal";
    public static final String _PARENT = "_parent";
    public static final String SCXML_SESSION_REGEXP = "_scxml_(.*)";
    private final MessageFormat scxmlMF = new MessageFormat("#_scxml_{0}");
    public static final Pattern SCXML_SESSION_PATTERN = Pattern.compile("_scxml_(.*)");
    public static final String SCXML_INVOKEID_REGEXP = "_(.*)";
    public static final Pattern SCXML_INVOKEID_PATTERN = Pattern.compile("_(.*)");
    private static final String $1 = "$1";
    private StateMachineEngine engine;

    public ScxmlIOProcessor(StateMachineEngine engine) {
        this.engine = engine;
    }

    public static ScxmlIOProcessor getInstance(Context context) {
        ScxmlIOProcessor scxmlIOProcessor = (ScxmlIOProcessor)context.searchIOProcessor(NAME);
        return scxmlIOProcessor;
    }

    public static URI getSourceFromContext(Context context) {
        ScxmlIOProcessor instance = ScxmlIOProcessor.getInstance(context);
        return instance.getLocation(context);
    }

    public static URI getParentSessionSource(Context context) {
        ScxmlIOProcessor instance = ScxmlIOProcessor.getInstance(context);
        String parentSessionId = context.getParentSessionId();
        return instance.getLocation(parentSessionId);
    }

    public URI getLocation(Context context) {
        URI uri = null;
        String id = context.getSessionId();
        uri = this.getLocation(id);
        return uri;
    }

    public URI getLocation(String sessionId) {
        String idURIString = this.scxmlMF.format(new Object[]{sessionId});
        URI result = null;
        result = URI.create(idURIString);
        return result;
    }

    public void sendMessageFromFSM(Message message) {
        Context originContext = this.getSessionFromURI(message.getSource());
        if (originContext != null) {
            URI target = message.getTarget();
            if (target == null) {
                this.createAndpushEventToFSM(message, originContext);
            } else {
                String targetFragment = target.getFragment();
                if (_INTERNAL.equals(targetFragment)) {
                    Event event = this.createEventFromMessage(message, EventType.INTERNAL, true);
                    originContext.offerInternalEvent(event);
                } else if (_PARENT.equals(targetFragment)) {
                    String parentId = originContext.getParentSessionId();
                    Context parentContext = this.engine.getSession(parentId);
                    if (parentContext != null) {
                        Event event = this.createEventFromChildren(message, EventType.EXTERNAL, originContext.getSessionId());
                        this.pushEventToFSM(event, parentContext);
                    } else {
                        this.logger.log(Level.SEVERE, "Error managing scxml send target: {0}. The parent id {1} has not beed found.", new Object[]{target, parentId});
                        this.sendCommErrorEvent(originContext);
                    }
                } else {
                    String targetSession = this.getSessionIdFromURIFragment(targetFragment);
                    if (this.isScxmlURI(targetFragment)) {
                        Context targetContext = this.engine.getSession(targetSession);
                        this.createAndpushEventToFSM(message, targetContext);
                    } else if (this.isInvokeURI(targetFragment)) {
                        String invokeId = targetSession;
                        if (originContext.isInvokeSessionActive(invokeId)) {
                            this.createAndpushEventToFSMFromInvoke(message, originContext);
                        } else {
                            this.logger.log(Level.WARNING, "The invoke session: {0} is not active in context: {1}.", new Object[]{invokeId, originContext.getSessionId()});
                            this.sendCommErrorEvent(originContext);
                        }
                    } else if (this.engine.isSessionActive(targetFragment)) {
                        Context targetContext = this.engine.getSession(targetFragment);
                        this.createAndpushEventToFSM(message, targetContext);
                    } else {
                        this.logger.log(Level.SEVERE, "Error managing scxml send target: {0}.", new Object[]{target});
                        this.sendCommErrorEvent(originContext);
                    }
                }
            }
        } else {
            this.logger.log(Level.SEVERE, "Error managing scxml send, cant find the origin session: {0}.", new Object[]{message.getSource()});
        }
    }

    protected void sendCommErrorEvent(Context originContext) {
        Event commErrorEvent = this.createCommErrorEvent(originContext);
        originContext.offerInternalEvent(commErrorEvent);
    }

    protected Event createCommErrorEvent(Context originContext) {
        Event commErrorEvent = BasicEvent.createPlatforEvent(PlatformEvents.COMMUNICATION_ERROR.getEventName(), this.getLocation(originContext), null);
        return commErrorEvent;
    }

    protected void createAndpushEventToFSM(Message message, Context context) {
        EventType eventType = EventType.EXTERNAL;
        Event event = this.createEventFromMessage(message, eventType, true);
        this.pushEventToFSM(event, context);
    }

    protected void createAndpushEventToFSMFromInvoke(Message message, Context context) {
        EventType eventType = EventType.EXTERNAL;
        Event event = this.createEventFromMessage(message, eventType, false);
        this.pushEventToFSM(event, context);
    }

    protected Event createEventFromChildren(Message message, EventType eventType, String originSessionId) {
        String eventName = message.getName();
        URI origin = message.getSource();
        String originType = NAME;
        String sendId = "";
        String invokeId = originSessionId;
        Object data = message.getBody();
        BasicEvent event = new BasicEvent(eventName, eventType, sendId, origin, originType, invokeId, data);
        return event;
    }

    protected Event createEventFromMessage(Message message, EventType eventType, boolean isSend) {
        String invokeId;
        String sendId;
        String eventName = message.getName();
        URI origin = message.getSource();
        String originType = NAME;
        if (isSend) {
            sendId = message.getId();
            invokeId = "";
        } else {
            sendId = "";
            invokeId = message.getId();
        }
        Object data = message.getBody();
        BasicEvent event = new BasicEvent(eventName, eventType, sendId, origin, originType, invokeId, data);
        return event;
    }

    public void sendEventToFSM(String sessionId, Event event) {
        if (this.engine.isSessionActive(sessionId)) {
            this.engine.pushEvent(sessionId, event);
        }
    }

    protected void pushEventToFSM(Event event, Context context) {
        String sessionId = context.getSessionId();
        this.sendEventToFSM(sessionId, event);
    }

    private Context getSessionFromURI(URI target) {
        Context context = null;
        String targetFragment = target.getFragment();
        String sessionId = this.getSessionIdFromURIFragment(targetFragment);
        context = this.engine.getSession(sessionId);
        return context;
    }

    private String getSessionIdFromURIFragment(String uriFragment) {
        String targetSessionId = null;
        Matcher matcher = SCXML_SESSION_PATTERN.matcher(uriFragment);
        if (matcher.matches()) {
            targetSessionId = matcher.replaceAll($1);
        } else {
            matcher = SCXML_INVOKEID_PATTERN.matcher(uriFragment);
            if (matcher.matches()) {
                targetSessionId = matcher.replaceAll($1);
            }
        }
        return targetSessionId;
    }

    protected boolean isScxmlURI(String uriFragment) {
        Matcher matcher = SCXML_SESSION_PATTERN.matcher(uriFragment);
        boolean isScxmlSessionId = matcher.matches();
        return isScxmlSessionId;
    }

    protected boolean isInvokeURI(String uriFragment) {
        Matcher matcher = SCXML_INVOKEID_PATTERN.matcher(uriFragment);
        boolean isScxmlSessionId = matcher.matches();
        return isScxmlSessionId;
    }

    public String getName() {
        return NAME;
    }

    public StateMachineEngine getEngine() {
        return this.engine;
    }

    public void setEngine(StateMachineEngine engine) {
        this.engine = engine;
    }

    public static void main(String[] args) {
        String a = "android://action/#sessionId";
        MessageFormat uriMF = new MessageFormat("android://{0}/{1}?{2}#{3}");
        a = uriMF.format(new Object[]{ScxmlIOProcessor.class.getCanonicalName(), "", "", "sessionid"});
        URI uri = URI.create(a);
        System.out.println("auth: " + uri.getAuthority());
        System.out.println("path: " + uri.getPath());
        System.out.println("specific: " + uri.getFragment());
    }
}

