/*
 * Decompiled with CFR 0.152.
 */
package com.notificationapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.notificationapi.exception.NotificationApiException;
import com.notificationapi.model.NotificationRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class NotificationApi
implements AutoCloseable {
    private static final String BASE_URL = "https://api.notificationapi.com";
    private final String clientId;
    private final String clientSecret;
    private final String authToken;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public NotificationApi(String clientId, String clientSecret) {
        if (clientId == null || clientId.trim().isEmpty()) {
            throw new IllegalArgumentException("clientId cannot be null or empty");
        }
        if (clientSecret == null || clientSecret.trim().isEmpty()) {
            throw new IllegalArgumentException("clientSecret cannot be null or empty");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authToken = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        this.httpClient = HttpClients.createDefault();
        this.objectMapper = new ObjectMapper();
    }

    public String send(NotificationRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getNotificationId() == null || request.getNotificationId().trim().isEmpty()) {
            throw new IllegalArgumentException("notificationId cannot be null or empty");
        }
        if (request.getUser() == null || request.getUser().getId() == null) {
            throw new IllegalArgumentException("user and user.id cannot be null");
        }
        try {
            return this.sendRequest("POST", "sender", request);
        }
        catch (IOException e) {
            throw new NotificationApiException("Failed to send notification", e);
        }
    }

    private String sendRequest(String method, String uri, Object data) throws IOException {
        String url = "https://api.notificationapi.com/" + this.clientId + "/" + uri;
        HttpGet request = switch (method) {
            case "GET" -> new HttpGet(url);
            case "POST" -> new HttpPost(url);
            case "PUT" -> new HttpPut(url);
            case "DELETE" -> new HttpDelete(url);
            case "PATCH" -> new HttpPatch(url);
            default -> throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        };
        request.setHeader("Authorization", "Basic " + this.authToken);
        request.setHeader("Content-Type", "application/json");
        if (data != null && !(request instanceof HttpGet) && !(request instanceof HttpDelete)) {
            String jsonPayload = this.objectMapper.writeValueAsString(data);
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new StringEntity(jsonPayload, StandardCharsets.UTF_8));
        }
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            throw new NotificationApiException("API request failed with status " + statusCode + ": " + responseBody, statusCode);
        }
        return responseBody;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

