/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.query;

import com.objectsql.annotation.RdTable;
import com.objectsql.query.AbstractQueryImpl;
import com.objectsql.query.IQuery;
import com.objectsql.query.MultiQuery;
import com.objectsql.spring.SpringUtils;
import com.objectsql.support.AliasTable;
import com.objectsql.support.Column;
import com.objectsql.support.Columns;
import com.objectsql.support.Condition;
import com.objectsql.support.Expression;
import com.objectsql.support.ExpressionType;
import com.objectsql.support.Join;
import com.objectsql.support.JoinType;
import com.objectsql.support.LambdaQuery;
import com.objectsql.support.Options;
import com.objectsql.support.Order;
import com.objectsql.support.QueryInfo;
import com.objectsql.utils.ORMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MultiQueryImpl
extends AbstractQueryImpl
implements MultiQuery {
    private List<MultiQuery> subQueries = new ArrayList<MultiQuery>();
    private List<String> usedAlias = new ArrayList<String>();
    private MultiQuery parentQuery;
    private List<String> aliasList = new ArrayList<String>();
    private Map<String, Object> aliasTable = new HashMap<String, Object>();
    private List<Column> groups = new ArrayList<Column>();
    private List<Column> groupCountsSelectColumns = new ArrayList<Column>();
    private List<Join> joins = new ArrayList<Join>();
    private Class<?> returnClass;
    private List<Column> returnColumns = new ArrayList<Column>();
    private List<Column> fixReturnColumns = new ArrayList<Column>();
    private Map<Object, Column> dataColumns = new LinkedHashMap<Object, Column>();
    private Map<Object, String> dataKeys = new LinkedHashMap<Object, String>();
    private boolean enableDataPermission = false;

    public MultiQueryImpl() {
    }

    public MultiQueryImpl(MultiQuery query) {
        this.parentQuery = query;
    }

    @Override
    public MultiQuery createQuery(Class<?> clazz, Column ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        this.fixReturnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public MultiQuery createQuery(Column ... columns) {
        this.returnColumns.clear();
        this.fixReturnColumns.clear();
        if (columns != null) {
            for (Column column : columns) {
                this.returnColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public MultiQuery createQuery(Class<?> clazz, Columns ... columns) {
        this.returnClass = clazz;
        this.returnColumns.clear();
        this.fixReturnColumns.clear();
        if (columns != null) {
            for (Columns column : columns) {
                List<Column> columnList = column.getColumnList();
                if (columnList.isEmpty()) continue;
                this.returnColumns.addAll(columnList);
            }
        }
        return this;
    }

    @Override
    public MultiQuery addReturnColumn(Column ... columns) {
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.returnColumns.add(columns[i]);
            }
        }
        return this;
    }

    @Override
    public MultiQuery addReturnColumn(Columns ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.returnColumns.addAll(columns[i].getColumnList());
            }
        }
        return this;
    }

    @Override
    public MultiQuery clearReturnColumns() {
        this.returnColumns.clear();
        return this;
    }

    @Override
    public MultiQuery addFixedReturnColumn(Column ... columns) {
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.fixReturnColumns.add(columns[i]);
            }
        }
        return this;
    }

    @Override
    public MultiQuery addFixedReturnColumn(Columns ... columns) {
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                this.fixReturnColumns.addAll(columns[i].getColumnList());
            }
        }
        return this;
    }

    @Override
    public MultiQuery clearFixedReturnColumns() {
        this.fixReturnColumns.clear();
        return this;
    }

    private String generateUniqueAlias(Object object) {
        int i = 0;
        String prefixAlias = null;
        prefixAlias = object instanceof IQuery ? "q" : (object instanceof Class ? ((Class)object).getSimpleName().substring(0, 1).toLowerCase(Locale.ROOT) : object.toString().substring(0, 1).toLowerCase(Locale.ROOT));
        String alias = prefixAlias + i;
        while (this.containsAlias(alias)) {
            alias = prefixAlias + ++i;
        }
        return alias;
    }

    @Override
    public AliasTable join(IQuery query) {
        String alias = this.generateUniqueAlias(query);
        return this.join(query, alias);
    }

    @Override
    public AliasTable join(IQuery query, String alias) {
        AliasTable table = new AliasTable(query);
        table.setAlias(alias);
        this.aliasTable.put(alias, query);
        this.addUsedAlias(alias);
        return table;
    }

    @Override
    public AliasTable table(IQuery query, String alias) {
        AliasTable table = new AliasTable(query);
        table.setAlias(alias);
        this.aliasList.add(alias);
        this.addUsedAlias(alias);
        this.aliasTable.put(alias, query);
        return table;
    }

    @Override
    public AliasTable table(IQuery query) {
        String alias = this.generateUniqueAlias(query);
        return this.table(query, alias);
    }

    @Override
    public AliasTable join(Class<?> clazz, String alias) {
        ORMUtils.whenEmpty(clazz, "AliasTable join class should not be null.");
        RdTable rdTable = SpringUtils.findAnnotation(clazz, RdTable.class);
        ORMUtils.whenEmpty(rdTable, "Should annotate RdTable");
        AliasTable table = new AliasTable(clazz);
        table.setAlias(alias);
        this.aliasTable.put(alias, clazz);
        this.addUsedAlias(alias);
        return table;
    }

    @Override
    public AliasTable join(Class<?> clazz, String clazzColumn, Column tableColumn) {
        AliasTable join = this.join(clazz);
        this.join(join, join.c(clazzColumn), tableColumn);
        return join;
    }

    @Override
    public AliasTable join(Class<?> clazz, JoinType joinType, String clazzColumn, Column tableColumn) {
        AliasTable join = this.join(clazz);
        this.join(join, joinType, join.c(clazzColumn), tableColumn);
        return join;
    }

    @Override
    public <T, R> AliasTable join(Class<?> clazz, LambdaQuery<T, R> clazzColumn, Column tableColumn) {
        AliasTable join = this.join(clazz);
        this.join(join, join.c(clazzColumn), tableColumn);
        return join;
    }

    @Override
    public <T, R> AliasTable join(Class<?> clazz, JoinType joinType, LambdaQuery<T, R> clazzColumn, Column tableColumn) {
        AliasTable join = this.join(clazz);
        this.join(join, joinType, join.c(clazzColumn), tableColumn);
        return join;
    }

    @Override
    public AliasTable join(Class<?> clazz) {
        String alias = this.generateUniqueAlias(clazz);
        return this.join(clazz, alias);
    }

    @Override
    public MultiQuery whereEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_EQUAL);
    }

    @Override
    public MultiQuery whereNotEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_NOT_EQUAL);
    }

    @Override
    public MultiQuery whereLike(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_LIKE);
    }

    @Override
    public MultiQuery whereNotLike(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_NOT_LIKE);
    }

    @Override
    public MultiQuery whereStartWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_START_WITH);
    }

    @Override
    public MultiQuery whereEndWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_END_WITH);
    }

    @Override
    public MultiQuery whereNotStartWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_NOT_START_WITH);
    }

    @Override
    public MultiQuery whereNotEndWith(Column left, String value) {
        return this.where(left, value, ExpressionType.CDT_NOT_END_WITH);
    }

    @Override
    public MultiQuery whereLess(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_LESS);
    }

    @Override
    public MultiQuery whereLessEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_LESS_EQUAL);
    }

    @Override
    public MultiQuery whereMore(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_MORE);
    }

    @Override
    public MultiQuery whereMoreEqual(Column left, Object value) {
        return this.where(left, value, ExpressionType.CDT_MORE_EQUAL);
    }

    @Override
    public MultiQuery whereIn(Column left, Collection value) {
        return this.where(left, value, ExpressionType.CDT_IN);
    }

    @Override
    public MultiQuery whereInValues(Column left, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(left, temp, ExpressionType.CDT_IN);
    }

    @Override
    public MultiQuery whereNotInValues(Column left, Object ... values) {
        List<Object> temp = null;
        temp = values != null ? Arrays.asList(values) : new ArrayList<Object>();
        return this.where(left, temp, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public MultiQuery whereNotIn(Column left, Collection value) {
        return this.where(left, value, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public MultiQuery whereNotInQuery(Column left, MultiQuery query) {
        return this.where(left, query, ExpressionType.CDT_NOT_IN);
    }

    @Override
    public MultiQuery whereBetween(Column left, Object value, Object andValue) {
        if (!ORMUtils.isEmpty(value) && !ORMUtils.isEmpty(andValue)) {
            Expression expression = new Expression(left, value, ExpressionType.CDT_BETWEEN);
            expression.setAndValue(andValue);
            this.addCondition(new Condition().and(expression));
        }
        return this;
    }

    @Override
    public MultiQuery whereInQuery(Column left, MultiQuery query) {
        return this.where(left, query, ExpressionType.CDT_IN);
    }

    @Override
    public AliasTable table(Class<?> clazz) {
        String alias = this.generateUniqueAlias(clazz);
        return this.table(clazz, alias);
    }

    @Override
    public AliasTable table(String tableName, String alias) {
        AliasTable table = new AliasTable(tableName);
        table.setAlias(alias);
        this.aliasList.add(alias);
        this.aliasTable.put(alias, tableName);
        this.addUsedAlias(alias);
        return table;
    }

    @Override
    public AliasTable table(String tableName) {
        String alias = this.generateUniqueAlias(tableName);
        return this.table(tableName, alias);
    }

    @Override
    public AliasTable table(Class<?> clazz, String alias) {
        RdTable rdTable;
        if (this.returnClass == null) {
            this.returnClass = clazz;
        }
        AliasTable table = null;
        if (clazz != null && (rdTable = SpringUtils.findAnnotation(clazz, RdTable.class)) != null) {
            table = new AliasTable(clazz);
            table.setAlias(alias);
            this.aliasList.add(alias);
            this.addUsedAlias(alias);
            this.aliasTable.put(alias, clazz);
        }
        return table;
    }

    @Override
    public MultiQuery whereIsNull(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_NULL)));
        return this;
    }

    @Override
    public MultiQuery whereIsNotNull(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_NOT_NULL)));
        return this;
    }

    @Override
    public MultiQuery whereIsEmpty(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_EMPTY)));
        return this;
    }

    @Override
    public MultiQuery whereIsNotEmpty(Column left) {
        this.addCondition(new Condition().and(new Expression(left, ExpressionType.CDT_IS_NOT_EMPTY)));
        return this;
    }

    @Override
    public MultiQuery where(Column left, Object value, ExpressionType type) {
        if (ORMUtils.isEmpty(value)) {
            if (type == ExpressionType.CDT_IS_NULL || type == ExpressionType.CDT_IS_NOT_NULL || type == ExpressionType.CDT_IS_EMPTY || type == ExpressionType.CDT_IS_NOT_EMPTY) {
                this.addCondition(new Condition().and(new Expression(left, type)));
            }
            return this;
        }
        this.addCondition(new Condition().and(new Expression(left, value, type)));
        return this;
    }

    @Override
    public MultiQuery where(Column left, Column value) {
        this.addCondition(new Condition().and(new Expression(left, value)));
        return this;
    }

    @Override
    public MultiQuery where(Condition condition) {
        if (condition != null) {
            this.addCondition(condition);
        }
        return this;
    }

    @Override
    public MultiQuery where(Expression ... expressions) {
        this.addCondition(new Condition().and(expressions));
        return this;
    }

    @Override
    public MultiQuery group(Column ... columns) {
        if (columns != null) {
            this.groups.addAll(Arrays.asList(columns));
        }
        return this;
    }

    @Override
    public List<Column> getGroupCountSelectColumns() {
        return this.groupCountsSelectColumns;
    }

    @Override
    public MultiQuery groupCountSelectColumn(Column ... columns) {
        if (columns != null) {
            this.groupCountsSelectColumns.addAll(Arrays.asList(columns));
        }
        return this;
    }

    @Override
    public MultiQuery group(Columns ... columns) {
        if (columns != null) {
            for (Columns column : columns) {
                this.groups.addAll(column.getColumnList());
            }
        }
        return this;
    }

    @Override
    public MultiQuery having(Column left, Object value, ExpressionType type) {
        if (ORMUtils.isEmpty(value)) {
            return this;
        }
        this.addHaving(new Condition().or(new Expression(left, value, type)));
        return this;
    }

    @Override
    public MultiQuery having(Column left, Column value) {
        this.addHaving(new Condition().and(new Expression(left, value)));
        return this;
    }

    @Override
    public MultiQuery having(Condition condition) {
        if (condition != null) {
            this.addHaving(condition);
        }
        return this;
    }

    @Override
    public MultiQuery having(Expression expression) {
        if (expression != null) {
            this.addHaving(new Condition().and(expression));
        }
        return this;
    }

    @Override
    public MultiQuery orderDesc(Column column) {
        this.orders.add(new Order(column, "DESC"));
        return this;
    }

    @Override
    public MultiQuery orderAsc(Column column) {
        this.orders.add(new Order(column, "ASC"));
        return this;
    }

    @Override
    public MultiQuery order(Order order) {
        if (order != null) {
            this.orders.add(order);
        }
        return this;
    }

    @Override
    public MultiQuery orders(List<Order> orderList) {
        if (orderList != null) {
            for (Order order : orderList) {
                this.orders.add(order);
            }
        }
        return this;
    }

    @Override
    public MultiQuery join(Join join) {
        this.joins.add(join);
        return this;
    }

    @Override
    public MultiQuery join(AliasTable table, Column left, Column right) {
        return this.join(new Join(table).on(left, right));
    }

    @Override
    public MultiQuery join(AliasTable table, JoinType joinType, Column left, Column right) {
        return this.join(new Join(table, joinType).on(left, right));
    }

    @Override
    public MultiQuery distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public MultiQuery enableDataPermission() {
        this.enableDataPermission = true;
        return this;
    }

    @Override
    public MultiQuery disableDataPermission() {
        this.enableDataPermission = false;
        return this;
    }

    @Override
    public boolean isEnableDataPermission() {
        return this.enableDataPermission;
    }

    @Override
    public String dataKey(Object dataType) {
        return this.dataKeys.get(dataType);
    }

    @Override
    public MultiQuery dataColumn(Object dataKey, Column column) {
        this.dataColumns.put(dataKey, column);
        return this;
    }

    @Override
    public MultiQuery dataColumn(Object dataType, String dataKey, Column column) {
        this.dataColumns.put(dataType, column);
        this.dataKeys.put(dataType, dataKey);
        return this;
    }

    @Override
    public Column dataColumn(Object dataType) {
        return this.dataColumns.get(dataType);
    }

    @Override
    public Class<?> getTable() {
        return null;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public List<String> getAliasList() {
        return this.aliasList;
    }

    @Override
    public Map<String, Object> getAliasTable() {
        return this.aliasTable;
    }

    @Override
    public List<Join> getJoins() {
        return this.joins;
    }

    @Override
    public List<Column> getGroups() {
        return this.groups;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public List<Column> getReturnColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        if (this.returnColumns.isEmpty()) {
            for (String alias : this.aliasList) {
                columnList.add(new Column(alias, "*"));
            }
        } else {
            columnList.addAll(this.returnColumns);
        }
        return columnList;
    }

    @Override
    public List<Column> getFinalReturnColumns() {
        ArrayList<Column> columnList = new ArrayList<Column>();
        columnList.addAll(this.getReturnColumns());
        columnList.addAll(this.fixReturnColumns);
        return columnList;
    }

    @Override
    public List<Column> getFixedReturnColumns() {
        return this.fixReturnColumns;
    }

    @Override
    public void addUsedAlias(String alias) {
        if (this.parentQuery == null) {
            this.usedAlias.add(alias);
        } else {
            for (MultiQuery temp = this.parentQuery; temp != null; temp = temp.parentQuery()) {
                if (temp.parentQuery() != null) continue;
                temp.addUsedAlias(alias);
            }
        }
    }

    @Override
    public boolean containsAlias(String alias) {
        if (this.parentQuery == null) {
            return this.usedAlias.contains(alias);
        }
        boolean hasC = false;
        for (MultiQuery temp = this.parentQuery; temp != null; temp = temp.parentQuery()) {
            if (temp.parentQuery() != null) continue;
            hasC = temp.containsAlias(alias);
            break;
        }
        return hasC;
    }

    @Override
    public MultiQuery newMultiQuery() {
        MultiQueryImpl query = new MultiQueryImpl(this);
        query.setTextTransformType(this.textTransformType());
        if (this.isLessDatePlus235959()) {
            query.enableLessDatePlus235959();
        }
        if (this.isLessEqualDatePlus235959()) {
            query.enableLessEqualDatePlus235959();
        }
        this.subQueries.add(query);
        return query;
    }

    @Override
    public MultiQuery parentQuery() {
        return this.parentQuery;
    }

    @Override
    public void setOptions(Options options) {
        this.options = options;
        for (MultiQuery query : this.subQueries) {
            query.setOptions(options);
        }
    }

    @Override
    public QueryInfo doQuery() {
        if (this.parentQuery != null) {
            return this.parentQuery.getOptions().doQuery(this, this.getPageable());
        }
        return this.options.doQuery(this, this.getPageable());
    }

    @Override
    public QueryInfo doQueryCount() {
        if (this.parentQuery != null) {
            return this.parentQuery.getOptions().doQueryCount(this);
        }
        return this.options.doQueryCount(this);
    }

    @Override
    public MultiQuery whereExists(MultiQuery query) {
        this.addCondition(new Condition().and(new Expression(ExpressionType.CDT_EXISTS, query)));
        return this;
    }

    @Override
    public MultiQuery whereNotExists(MultiQuery query) {
        this.addCondition(new Condition().and(new Expression(ExpressionType.CDT_NOT_EXISTS, query)));
        return this;
    }
}

