/*
 * Decompiled with CFR 0.152.
 */
package com.paymentplugins;

import com.paymentplugins.Json;
import java.lang.reflect.Field;
import java.util.List;

public abstract class JsonBuilder {
    private static String OPEN_BRACKET = "{";
    private static String CLOSE_BRACKET = "}";
    private static String OPEN_ARRAY = "[";
    private static String CLOSE_ARRAY = "]";
    private boolean isStart = true;

    public String buildJsonObject(String name) {
        StringBuilder builder = new StringBuilder();
        if (name != null) {
            builder.append(String.format("\"%s\" : ", name));
        }
        builder.append(OPEN_BRACKET);
        this.toJson(builder);
        builder.append(CLOSE_BRACKET);
        return builder.toString();
    }

    public void toJson(StringBuilder builder) {
        Field[] fields;
        Class<?> klass = this.getClass();
        for (Field field : fields = klass.getDeclaredFields()) {
            try {
                String json = null;
                field.setAccessible(true);
                Class<?> klazz = field.getType();
                if (JsonBuilder.class.isAssignableFrom(klazz)) {
                    JsonBuilder handler = this.getHandlerFromField(field);
                    json = handler.buildJsonObject(field.getName());
                } else if (List.class.isAssignableFrom(klazz)) {
                    json = this.buildJsonArray(field);
                } else {
                    Json annotation = field.getAnnotation(Json.class);
                    if (annotation != null) {
                        json = this.buildNameValuePair(field);
                    }
                }
                if (!this.isStart) {
                    builder.append(",");
                }
                if (json == null) continue;
                builder.append(json);
                this.isStart = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JsonBuilder getHandlerFromField(Field field) {
        JsonBuilder handler = null;
        try {
            handler = (JsonBuilder)field.get(this);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return handler;
    }

    private String buildNameValuePair(Field field) throws Exception {
        String name = field.getName();
        Object nameValuePair = null;
        try {
            String value = (String)field.get(this);
            if (value != null) {
                return String.format("\"%s\" : \"%s\"", name, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new Exception(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new Exception(e.getMessage());
        }
        return null;
    }

    private String buildJsonArray(Field field) throws Exception {
        StringBuilder builder = new StringBuilder(String.format("\"%s\" : ", field.getName()));
        builder.append(OPEN_ARRAY);
        try {
            List list = (List)field.get(this);
            for (int i = 0; i < list.size(); ++i) {
                JsonBuilder handler = (JsonBuilder)list.get(i);
                String json = handler.buildJsonObject(null);
                builder.append(json);
                if (i + 1 == list.size()) continue;
                builder.append(",");
            }
        }
        catch (IllegalArgumentException e) {
            throw new Exception(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new Exception(e.getMessage());
        }
        builder.append(CLOSE_ARRAY);
        return builder.toString();
    }
}

