/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.serial;

import com.rm5248.serial.NoSuchPortException;
import com.rm5248.serial.NotASerialPortException;
import com.rm5248.serial.SerialPort;
import java.io.IOException;

public class SerialPortBuilder {
    String portName;
    SerialPort.BaudRate baudRate = SerialPort.BaudRate.B9600;
    SerialPort.DataBits dataBits = SerialPort.DataBits.DATABITS_8;
    SerialPort.FlowControl flowControl = SerialPort.FlowControl.NONE;
    SerialPort.Parity parity = SerialPort.Parity.NONE;
    SerialPort.StopBits stopBits = SerialPort.StopBits.STOPBITS_1;
    int controlFlags = 7;

    public SerialPortBuilder setPort(String portName) {
        this.portName = portName;
        return this;
    }

    public SerialPortBuilder setBaudRate(SerialPort.BaudRate baudRate) {
        this.baudRate = baudRate;
        return this;
    }

    public SerialPortBuilder setDataBits(SerialPort.DataBits dataBits) {
        this.dataBits = dataBits;
        return this;
    }

    public SerialPortBuilder setFlowControl(SerialPort.FlowControl flowControl) {
        this.flowControl = flowControl;
        return this;
    }

    public SerialPortBuilder setParity(SerialPort.Parity parity) {
        this.parity = parity;
        return this;
    }

    public SerialPortBuilder setStopBits(SerialPort.StopBits stopBits) {
        this.stopBits = stopBits;
        return this;
    }

    public SerialPortBuilder setControlFlags(int controlFlags) {
        this.controlFlags = controlFlags;
        return this;
    }

    public SerialPort build() throws NoSuchPortException, NotASerialPortException, IOException {
        return new SerialPort(this);
    }
}

