/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.commands.CommandEndSub;
import com.scriptbasic.executors.commands.CommandGlobal;
import com.scriptbasic.executors.commands.CommandLocal;
import com.scriptbasic.executors.commands.CommandMethod;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.executors.commands.CommandUse;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import java.util.Map;

public abstract class AbstractBasicProgramPostprocessing
implements BuildableProgram {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBasicProgramPostprocessing.class);
    private Command startCommand = null;

    @Override
    public Command getStartCommand() {
        if (this.startCommand == null) {
            this.startCommand = this.getFirstCommand();
        }
        return this.startCommand;
    }

    protected abstract Map<String, CommandSub> getSubroutineMap();

    private void collectSubroutines() throws GenericSyntaxException {
        for (Command command = this.getFirstCommand(); command != null; command = command.getNextCommand()) {
            if (!(command instanceof CommandSub)) continue;
            CommandSub commandSub = (CommandSub)command;
            if (this.getSubroutineMap().containsKey(commandSub.getSubName())) {
                throw new GenericSyntaxException("The subroutine '" + commandSub.getSubName() + "' is defined more than once");
            }
            this.getSubroutineMap().put(commandSub.getSubName(), (CommandSub)command);
        }
    }

    private void skipDeclarations() {
        boolean loopIsInSub = false;
        int skipNr = 0;
        for (Command command = this.getFirstCommand(); command != null; command = command.getNextCommand()) {
            ++skipNr;
            if (loopIsInSub) {
                if (!(command instanceof CommandEndSub)) continue;
                loopIsInSub = false;
                continue;
            }
            if (command instanceof CommandSub) {
                loopIsInSub = true;
                continue;
            }
            this.startCommand = command;
            LOG.info("basic program starts on the line #" + skipNr, new Object[0]);
            break;
        }
    }

    private void checkLocalAndGlobalDeclarations() throws AnalysisException {
        boolean loopIsInSub = false;
        boolean subHeadClosed = false;
        for (Command command = this.getFirstCommand(); command != null; command = command.getNextCommand()) {
            if (loopIsInSub) {
                if (command instanceof CommandEndSub) {
                    loopIsInSub = false;
                    continue;
                }
                if (command instanceof CommandSub) {
                    AbstractBasicProgramPostprocessing.signalNestedSub();
                }
                if (command instanceof CommandUse) {
                    AbstractBasicProgramPostprocessing.signalLocalCommandUse();
                }
                if (command instanceof CommandMethod) {
                    AbstractBasicProgramPostprocessing.signalLocalCommandMethod();
                }
                if (subHeadClosed) {
                    if (!(command instanceof CommandLocal) && !(command instanceof CommandGlobal)) continue;
                    AbstractBasicProgramPostprocessing.signalMisplacedGlobalOrLocal();
                    continue;
                }
                subHeadClosed = !AbstractBasicProgramPostprocessing.commandIsSubHeadCommand(command);
                continue;
            }
            if (command instanceof CommandLocal) {
                AbstractBasicProgramPostprocessing.signalGlobalLocal();
            }
            if (!(command instanceof CommandSub)) continue;
            loopIsInSub = true;
            subHeadClosed = false;
        }
    }

    private static boolean commandIsSubHeadCommand(Command command) {
        return command instanceof CommandLocal || command instanceof CommandGlobal;
    }

    private static void signalGlobalLocal() throws AnalysisException {
        throw new GenericSyntaxException("Command 'LOCAL' can only be used inside a subroutine.");
    }

    private static void signalLocalCommandUse() throws AnalysisException {
        throw new GenericSyntaxException("Command 'USE' should not be used inside a subroutine.");
    }

    private static void signalLocalCommandMethod() throws AnalysisException {
        throw new GenericSyntaxException("Command 'METHOD' should not be used inside a subroutine.");
    }

    private static void signalMisplacedGlobalOrLocal() throws AnalysisException {
        throw new GenericSyntaxException("Global and Local declarations shoud be the first definitions in the Sub");
    }

    private static void signalNestedSub() throws AnalysisException {
        throw new GenericSyntaxException("Subroutines can not be nested into each other");
    }

    protected abstract Command getFirstCommand();

    @Override
    public void postprocess() throws AnalysisException {
        this.startCommand = this.getFirstCommand();
        this.checkLocalAndGlobalDeclarations();
        this.skipDeclarations();
        this.collectSubroutines();
    }
}

