/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.leftvalue;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.LeftValueAnalyzer;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.SimpleLeftValueAnalyzer;
import com.scriptbasic.utility.FactoryUtility;

public class BasicSimpleLeftValueAnalyzer
implements LeftValueAnalyzer,
SimpleLeftValueAnalyzer {
    private Factory factory;

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public LeftValue analyze() throws AnalysisException {
        BasicLeftValue leftValue = null;
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.getFactory());
        LexicalElement lexicalElement = lexicalAnalyzer.peek();
        if (!lexicalElement.isIdentifier().booleanValue()) {
            throw new GenericSyntaxException("left value should start with an identifier", lexicalElement, null);
        }
        lexicalAnalyzer.get();
        leftValue = new BasicLeftValue();
        leftValue.setIdentifier(lexicalElement.getLexeme());
        return leftValue;
    }
}

