/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors;

import com.scriptbasic.executors.BasicMethodRegistry;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.hooks.NullHook;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.Configuration;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.HierarchicalVariableMap;
import com.scriptbasic.interfaces.InterpreterHook;
import com.scriptbasic.interfaces.MethodRegistry;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.memory.MixedBasicVariableMap;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.HookRegisterUtility;
import com.scriptbasic.utility.MethodRegisterUtility;
import com.scriptbasic.utility.RightValueUtility;
import com.scriptbasic.utility.RuntimeUtility;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public final class BasicExtendedInterpreter
implements ExtendedInterpreter {
    private BuildableProgram program;
    private Reader reader;
    private Writer writer;
    private Writer errorWriter;
    private InterpreterHook hook = null;
    private InterpreterHook hookedHook = null;
    private final MixedBasicVariableMap variables = new MixedBasicVariableMap();
    private Command nextCommand;
    private Command currentCommand;
    private final Map<String, Object> interpreterStateMap = new HashMap<String, Object>();
    private Factory factory;
    private final Map<String, Class<?>> useMap = new HashMap();
    private final MethodRegistry basicMethodRegistry = new BasicMethodRegistry();
    private final Stack<Command> commandStack = new Stack();
    private final Stack<Command> nextCommandStack = new Stack();
    private RightValue returnValue;

    @Override
    public InterpreterHook getHook() {
        return this.hook;
    }

    @Override
    public void disableHook() {
        if (this.hook != null) {
            this.hookedHook = this.hook;
            this.hook = null;
        }
    }

    @Override
    public void enableHook() {
        if (this.hookedHook != null) {
            this.hook = this.hookedHook;
            this.hookedHook = null;
        }
    }

    @Override
    public void registerHook(InterpreterHook hook) {
        hook.setNext(this.hook);
        hook.setInterpreter(this);
        this.hook = hook;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setErrorWriter(Writer errorWriter) {
        this.errorWriter = errorWriter;
    }

    @Override
    public void setProgram(BuildableProgram buildableProgram) {
        this.program = buildableProgram;
    }

    @Override
    public HierarchicalVariableMap getVariables() {
        return this.variables;
    }

    @Override
    public CommandSub getSubroutine(String name) {
        Command command = this.program.getNamedCommand(name);
        if (command instanceof CommandSub) {
            return (CommandSub)command;
        }
        return null;
    }

    @Override
    public void registerFunctions(Class<?> klass) {
        MethodRegisterUtility.registerFunctions(klass, this);
    }

    @Override
    public void execute() throws ExecutionException {
        Command command = this.program.getStartCommand();
        MethodRegisterUtility.registerFunctions(RuntimeUtility.class, this);
        this.registerHook(new NullHook());
        HookRegisterUtility.registerHooks(this);
        if (this.hook != null) {
            this.hook.init();
        }
        this.execute(command);
    }

    @Override
    public void execute(Command startCommand) throws ExecutionException {
        Command command = startCommand;
        while (command != null) {
            this.nextCommand = command.getNextCommand();
            this.currentCommand = command;
            if (this.hook != null) {
                this.hook.beforeExecute(command);
            }
            command.checkedExecute(this);
            if (this.hook != null) {
                this.hook.afterExecute(command);
            }
            this.currentCommand = null;
            command = this.nextCommand;
        }
    }

    @Override
    public void setVariable(String name, Object value) throws ExecutionException {
        RightValue rightValue = RightValueUtility.createRightValue(value);
        this.getVariables().setVariable(name, rightValue);
    }

    @Override
    public Object getVariable(String name) throws ExecutionException {
        RightValue rightValue = this.getVariables().getVariableValue(name);
        return rightValue == null ? null : ((AbstractPrimitiveRightValue)rightValue).getValue();
    }

    @Override
    public Object call(String functionName, Object[] arguments) {
        return null;
    }

    @Override
    public BuildableProgram getProgram() {
        return this.program;
    }

    @Override
    public void setNextCommand(Command nextCommand) {
        this.nextCommand = nextCommand;
    }

    @Override
    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    public Map<String, Object> getMap() {
        return this.interpreterStateMap;
    }

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public Map<String, Class<?>> getUseMap() {
        return this.useMap;
    }

    @Override
    public Method getJavaMethod(Class<?> klass, String methodName) throws ExecutionException {
        return this.basicMethodRegistry.getJavaMethod(klass, methodName);
    }

    @Override
    public void registerJavaMethod(String alias, Class<?> klass, String methodName, Class<?>[] argumentTypes) {
        if (this.hook != null) {
            this.hook.beforeRegisteringJavaMethod(alias, klass, methodName, argumentTypes);
        }
        this.basicMethodRegistry.registerJavaMethod(alias, klass, methodName, argumentTypes);
    }

    @Override
    public void push(Command command) {
        if (this.hook != null) {
            this.hook.beforePush(command);
        }
        this.commandStack.push(command);
        this.nextCommandStack.push(this.nextCommand);
        this.getVariables().newFrame();
        if (this.hook != null) {
            this.hook.afterPush(command);
        }
    }

    @Override
    public void push() {
        this.push(this.currentCommand);
    }

    @Override
    public Command pop() {
        if (this.hook != null) {
            this.hook.beforePop();
        }
        this.getVariables().dropFrame();
        this.nextCommand = this.nextCommandStack.pop();
        Command command = this.commandStack.pop();
        if (this.hook != null) {
            this.hook.afterPop(command);
        }
        return command;
    }

    @Override
    public void setReturnValue(RightValue returnValue) {
        this.returnValue = returnValue;
        if (this.hook != null) {
            this.hook.setReturnValue(returnValue);
        }
    }

    @Override
    public RightValue getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Configuration getConfiguration() {
        return FactoryUtility.getConfiguration(this.getFactory());
    }
}

