/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.memory;

import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.interfaces.VariableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class BasicVariableMap
implements VariableMap {
    private final Map<String, RightValue> variableMap = new HashMap<String, RightValue>();
    private final Set<String> variableNameSet = new HashSet<String>();
    private boolean variableNamesAreCaseSensitive = false;
    private boolean variableNamesAreStrictCased = false;

    BasicVariableMap() {
    }

    BasicVariableMap(BasicVariableMap that) {
        this.variableNamesAreCaseSensitive = that.variableNamesAreCaseSensitive;
        this.variableNamesAreStrictCased = that.variableNamesAreStrictCased;
    }

    public void setCaseSensitive() {
        this.variableNamesAreCaseSensitive = true;
        this.variableNamesAreStrictCased = false;
    }

    public void setCaseFreak() {
        this.variableNamesAreCaseSensitive = false;
        this.variableNamesAreStrictCased = true;
    }

    public void setCaseIgnorant() {
        this.variableNamesAreCaseSensitive = false;
        this.variableNamesAreStrictCased = false;
    }

    protected String converted(String name) {
        return this.variableNamesAreCaseSensitive ? name : name.toUpperCase();
    }

    void assertCorrectCasing(String variableName) throws ExecutionException {
        String convertedName;
        if (this.variableNamesAreStrictCased && this.variableMap.containsKey(convertedName = this.converted(variableName)) && !this.variableNameSet.contains(variableName)) {
            throw new BasicRuntimeException("Variable '" + variableName + "' has different casing.");
        }
    }

    void registerVariableCasing(String name) {
        this.variableNameSet.add(name);
    }

    @Override
    public RightValue getVariableValue(String variableName) throws ExecutionException {
        return this.variableExists(variableName) != false ? this.variableMap.get(this.converted(variableName)) : null;
    }

    @Override
    public Boolean variableExists(String variableName) throws ExecutionException {
        this.assertCorrectCasing(variableName);
        return this.variableMap.containsKey(this.converted(variableName));
    }

    @Override
    public Boolean variableDefined(String variableName) throws ExecutionException {
        return this.variableExists(variableName) != false && this.getVariableValue(variableName) != null;
    }

    @Override
    public void setVariable(String variableName, RightValue rightValue) throws ExecutionException {
        this.assertCorrectCasing(variableName);
        this.registerVariableCasing(variableName);
        this.variableMap.put(this.converted(variableName), rightValue);
    }
}

