/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.expression;

import com.scriptbasic.executors.operators.AbstractBinaryOperator;
import com.scriptbasic.executors.operators.AddOperator;
import com.scriptbasic.executors.operators.DivideOperator;
import com.scriptbasic.executors.operators.EqualsOperator;
import com.scriptbasic.executors.operators.GreaterOrEqualOperator;
import com.scriptbasic.executors.operators.GreaterThanOperator;
import com.scriptbasic.executors.operators.IntegerDivideOperator;
import com.scriptbasic.executors.operators.JavaObjectFieldAccessOperator;
import com.scriptbasic.executors.operators.LessOrEqualOperator;
import com.scriptbasic.executors.operators.LessThanOperator;
import com.scriptbasic.executors.operators.LogicalAndOperator;
import com.scriptbasic.executors.operators.LogicalOrOperator;
import com.scriptbasic.executors.operators.MinusOperator;
import com.scriptbasic.executors.operators.ModuloOperator;
import com.scriptbasic.executors.operators.MultiplyOperator;
import com.scriptbasic.executors.operators.NotEqualOperator;
import com.scriptbasic.executors.operators.PowerOperator;
import com.scriptbasic.syntax.expression.AbstractExpressionAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BasicExpressionAnalyzer
extends AbstractExpressionAnalyzer {
    private static final Integer MAXIMUM_PRIORITY = 6;
    private static final List<Map<String, Class<? extends AbstractBinaryOperator>>> BASIC_OPERATOR_MAPS = new ArrayList<Map<String, Class<? extends AbstractBinaryOperator>>>(MAXIMUM_PRIORITY + 1);

    private static Map<String, Class<? extends AbstractBinaryOperator>> getStaticOperatorMap(Integer priority) {
        Map<String, Class<? extends AbstractBinaryOperator>> operatorMap = BASIC_OPERATOR_MAPS.get(priority);
        if (operatorMap == null) {
            operatorMap = new HashMap<String, Class<? extends AbstractBinaryOperator>>();
            BASIC_OPERATOR_MAPS.set(priority, operatorMap);
        }
        return operatorMap;
    }

    @Override
    protected Integer getMaximumPriority() {
        return MAXIMUM_PRIORITY;
    }

    @Override
    protected Map<String, Class<? extends AbstractBinaryOperator>> getOperatorMap(Integer priority) {
        return BasicExpressionAnalyzer.getStaticOperatorMap(priority);
    }

    static {
        Integer i = 0;
        while (i <= MAXIMUM_PRIORITY) {
            BASIC_OPERATOR_MAPS.add(null);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        Map<String, Class<? extends AbstractBinaryOperator>> opMap = null;
        int priority = 0;
        opMap = BasicExpressionAnalyzer.getStaticOperatorMap(++priority);
        opMap.put(".", JavaObjectFieldAccessOperator.class);
        opMap = BasicExpressionAnalyzer.getStaticOperatorMap(++priority);
        opMap.put("^", PowerOperator.class);
        opMap = BasicExpressionAnalyzer.getStaticOperatorMap(++priority);
        opMap.put("*", MultiplyOperator.class);
        opMap.put("/", DivideOperator.class);
        opMap.put("%", ModuloOperator.class);
        opMap.put("div", IntegerDivideOperator.class);
        opMap = BasicExpressionAnalyzer.getStaticOperatorMap(++priority);
        opMap.put("+", AddOperator.class);
        opMap.put("-", MinusOperator.class);
        opMap = BasicExpressionAnalyzer.getStaticOperatorMap(++priority);
        opMap.put("=", EqualsOperator.class);
        opMap.put("<", LessThanOperator.class);
        opMap.put(">", GreaterThanOperator.class);
        opMap.put(">=", GreaterOrEqualOperator.class);
        opMap.put("<=", LessOrEqualOperator.class);
        opMap.put("<>", NotEqualOperator.class);
        opMap = BasicExpressionAnalyzer.getStaticOperatorMap(++priority);
        opMap.put("and", LogicalAndOperator.class);
        opMap.put("or", LogicalOrOperator.class);
    }
}

