/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.executors.operators.AbstractBinaryFullCircuitOperator;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.RightValue;

public abstract class AbstractCompareOperator
extends AbstractBinaryFullCircuitOperator {
    protected static int compareJavaObjectTo(BasicJavaObjectValue f, RightValue op) throws BasicRuntimeException {
        Object o = BasicJavaObjectValue.asObject(op);
        if (f.getValue() instanceof Comparable && o instanceof Comparable) {
            Comparable a = (Comparable)f.getValue();
            Comparable b = (Comparable)o;
            return a.compareTo(b);
        }
        throw new BasicRuntimeException("Can not compare the java objects, at least one of them is not comparable");
    }

    protected abstract Boolean compareTo(BasicDoubleValue var1, RightValue var2) throws BasicRuntimeException;

    protected abstract Boolean compareTo(BasicLongValue var1, RightValue var2) throws BasicRuntimeException;

    protected abstract Boolean compareTo(BasicStringValue var1, RightValue var2) throws BasicRuntimeException;

    protected abstract Boolean compareTo(BasicJavaObjectValue var1, RightValue var2) throws BasicRuntimeException;

    protected abstract Boolean compareTo(BasicBooleanValue var1, RightValue var2) throws BasicRuntimeException;

    @Override
    protected RightValue evaluateOn(RightValue leftOperand, RightValue rightOperand) throws BasicRuntimeException {
        if (leftOperand.isDouble().booleanValue()) {
            return new BasicBooleanValue(this.compareTo((BasicDoubleValue)leftOperand, rightOperand));
        }
        if (leftOperand.isLong().booleanValue()) {
            return new BasicBooleanValue(this.compareTo((BasicLongValue)leftOperand, rightOperand));
        }
        if (leftOperand.isBoolean().booleanValue()) {
            return new BasicBooleanValue(this.compareTo((BasicBooleanValue)leftOperand, rightOperand));
        }
        if (leftOperand.isString().booleanValue()) {
            return new BasicBooleanValue(this.compareTo((BasicStringValue)leftOperand, rightOperand));
        }
        if (leftOperand.isJavaObject().booleanValue()) {
            return new BasicBooleanValue(this.compareTo((BasicJavaObjectValue)leftOperand, rightOperand));
        }
        return null;
    }
}

