/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.RightValue;

public final class BasicBooleanValue
extends AbstractPrimitiveRightValue<Boolean> {
    public BasicBooleanValue(Boolean b) {
        this.setValue(b);
    }

    private static Boolean convertNumeric(AbstractNumericRightValue<Number> originalValue) {
        Boolean convertedValue = null;
        if (originalValue.isLong().booleanValue()) {
            Long l = (Long)originalValue.getValue();
            convertedValue = l != null && l != 0L;
        } else if (originalValue.isDouble().booleanValue()) {
            Double d = (Double)originalValue.getValue();
            convertedValue = d != null && d != 0.0;
        }
        return convertedValue;
    }

    public static Boolean asBoolean(RightValue originalValue) throws BasicRuntimeException {
        Boolean convertedValue = null;
        if (originalValue == null) {
            convertedValue = Boolean.FALSE;
        } else if (originalValue instanceof AbstractNumericRightValue) {
            convertedValue = BasicBooleanValue.convertNumeric((AbstractNumericRightValue)originalValue);
        } else if (originalValue.isBoolean().booleanValue()) {
            convertedValue = (Boolean)((BasicBooleanValue)originalValue).getValue();
        } else if (originalValue.isString().booleanValue()) {
            String s = (String)((BasicStringValue)originalValue).getValue();
            convertedValue = s != null && s.length() > 0;
        } else if (originalValue.isJavaObject().booleanValue()) {
            Object o = ((BasicJavaObjectValue)originalValue).getValue();
            convertedValue = o instanceof Boolean ? (Boolean)o : Boolean.valueOf(o != null);
        }
        return convertedValue;
    }
}

