/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer.elements;

import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.SourceReader;
import com.scriptbasic.lexer.BasicLexialElementFactory;
import com.scriptbasic.lexer.BasicLexicalElement;
import com.scriptbasic.lexer.elements.AbstractElementAnalyzer;

public class Decimal
extends AbstractElementAnalyzer {
    private static final int DECIMAL_NUMBER_STRINGBUILDER_INITIAL_CAPACITY = 20;

    public Decimal(SourceReader reader) {
        super(reader);
    }

    @Override
    public LexicalElement read() throws LexicalException {
        Integer ch = this.getReader().get();
        this.getReader().pushBack(ch);
        if (ch != null && Character.isDigit(ch)) {
            boolean floatFormat;
            BasicLexicalElement le = BasicLexialElementFactory.create(this.getReader());
            StringBuilder digits = new StringBuilder(20);
            this.processDigits(digits);
            ch = this.getReader().get();
            if (Integer.valueOf(46).equals(ch)) {
                floatFormat = this.processFraction(digits);
            } else {
                this.getReader().pushBack(ch);
                floatFormat = this.processExponent(digits);
            }
            String s = digits.toString();
            le.setLexeme(s);
            if (floatFormat) {
                le.setType(1);
                le.setDoubleValue(Double.parseDouble(s));
            } else {
                le.setType(2);
                le.setLongValue(Long.parseLong(s));
            }
            return le;
        }
        return null;
    }

    private boolean processFraction(StringBuilder fractionPart) {
        boolean floatFormat = false;
        Integer ch = this.getReader().get();
        if (ch != null && Character.isDigit(ch)) {
            floatFormat = true;
            fractionPart.appendCodePoint(46);
            this.getReader().pushBack(ch);
            this.processDigits(fractionPart);
            this.processExponent(fractionPart);
        } else {
            floatFormat = false;
            this.getReader().pushBack(ch);
            this.getReader().pushBack(46);
        }
        return floatFormat;
    }

    private void processSignedExponenChars(StringBuilder exponentCharacters, Integer signChar, Integer expChar) {
        Integer ch = this.getReader().get();
        if (ch != null && Character.isDigit(ch)) {
            exponentCharacters.appendCodePoint(expChar);
            exponentCharacters.appendCodePoint(signChar);
            this.getReader().pushBack(ch);
            this.processDigits(exponentCharacters);
        } else {
            this.getReader().pushBack(signChar);
            this.getReader().pushBack(expChar);
        }
    }

    private void processExponenChars(StringBuilder exponentCharacters, Integer expChar) {
        Integer ch = this.getReader().get();
        if (ch != null && (ch.equals(45) || ch.equals(43))) {
            this.processSignedExponenChars(exponentCharacters, ch, expChar);
        } else if (ch != null && Character.isDigit(ch)) {
            exponentCharacters.appendCodePoint(expChar);
            this.getReader().pushBack(ch);
            this.processDigits(exponentCharacters);
        } else {
            this.getReader().pushBack(expChar);
        }
    }

    private boolean processExponent(StringBuilder exponentCharacters) {
        boolean thereWasExponentPart = true;
        Integer ch = this.getReader().get();
        if (ch != null && (ch.equals(101) || ch.equals(69))) {
            this.processExponenChars(exponentCharacters, ch);
        } else {
            thereWasExponentPart = false;
            this.getReader().pushBack(ch);
        }
        return thereWasExponentPart;
    }

    private void processDigits(StringBuilder digits) {
        Integer ch = this.getReader().get();
        while (ch != null && Character.isDigit(ch)) {
            digits.appendCodePoint(ch);
            ch = this.getReader().get();
        }
        this.getReader().pushBack(ch);
    }
}

