/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.main;

import com.scriptbasic.factories.Context;
import com.scriptbasic.factories.ContextBuilder;
import com.scriptbasic.utility.functions.file.FileHandlingFunctions;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Optional;

public class CommandLine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block7: {
            if (args.length != 1) {
                System.err.println("usage: java [-Dsb4j.extensionclasses=comma separated list of extension classes] [-cp classpath for extensions] -jar jscriptbasic-x.y.z basicprogram.sb");
                System.exit(1);
            }
            String basicProgramFileName = args[0];
            PrintWriter output = new PrintWriter(System.out);
            PrintWriter error = new PrintWriter(System.err);
            try {
                InputStreamReader input = new InputStreamReader(System.in);
                Context ctx = ContextBuilder.from(new FileReader(basicProgramFileName), (Reader)input, (Writer)output, (Writer)error);
                ctx.interpreter.registerFunctions(FileHandlingFunctions.class);
                CommandLine.registerSystemPropertyDefinedClasses(ctx);
                ctx.interpreter.setProgram(ctx.syntaxAnalyzer.analyze());
                ctx.interpreter.execute();
            }
            catch (Exception exception) {
                Throwable cause = Optional.ofNullable(exception.getCause()).orElse(exception);
                if (cause.getMessage() != null) {
                    System.err.println("ERROR: " + cause.getMessage());
                    break block7;
                }
                throw exception;
            }
            finally {
                output.flush();
                error.flush();
            }
        }
    }

    private static void registerSystemPropertyDefinedClasses(Context ctx) throws ClassNotFoundException {
        String classes = System.getProperty("sb4j.extensionclasses");
        if (classes != null && classes.length() > 0) {
            String[] classNames;
            for (String className : classNames = classes.split(",")) {
                Class<?> klass = Class.forName(className);
                ctx.interpreter.registerFunctions(klass);
            }
        }
    }
}

