/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.readers;

import com.scriptbasic.interfaces.HierarchicalSourceReader;
import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.interfaces.SourceReader;
import java.util.Stack;

public class GenericHierarchicalSourceReader
implements HierarchicalSourceReader {
    private final Stack<SourceReader> readerStack = new Stack();
    private SourceReader reader;

    public GenericHierarchicalSourceReader(SourceReader reader) {
        this.reader = reader;
    }

    @Override
    public void include(SourceReader reader) {
        if (this.reader != null) {
            this.readerStack.push(this.reader);
        }
        this.reader = reader;
    }

    @Override
    public String getFileName() {
        return this.reader.getFileName();
    }

    @Override
    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    @Override
    public int getPosition() {
        return this.reader.getPosition();
    }

    @Override
    public void pushBack(Integer ch) {
        this.reader.pushBack(ch);
    }

    @Override
    public Integer get() {
        Integer ch = this.reader.get();
        while (ch == null && !this.readerStack.isEmpty()) {
            this.reader = this.readerStack.pop();
            ch = this.reader.get();
        }
        return ch;
    }

    @Override
    public SourceProvider getSourceProvider() {
        return this.reader.getSourceProvider();
    }
}

