/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.api.BasicFunction;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Configuration;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.ExtensionInterfaceVersion;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.NoInstance;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodRegisterUtility
implements ExtensionInterfaceVersion {
    private static Logger LOG = LoggerFactory.getLogger();

    private MethodRegisterUtility() {
        NoInstance.isPossible();
    }

    public static void registerFunctions(Class<?> klass, ExtendedInterpreter interpreter) throws BasicRuntimeException {
        FunctionLoadParameters method = new FunctionLoadParameters();
        for (Method methodObj : klass.getMethods()) {
            method.initParameters(methodObj, klass);
            if (!method.isFunctionAnnotated()) continue;
            if (!Modifier.isStatic(methodObj.getModifiers())) {
                LOG.error("Method {}, {} , {}, {} is NOT STATIC, CAN NOT BE REGISTERED", method.alias, method.methodName, method.klass, method.classifications);
                throw new BasicRuntimeException("Method " + methodObj + " is not static.");
            }
            method.setAlias();
            method.setMethodName();
            method.setClass();
            method.setClassification();
            LOG.info("Registering {}, {} , {}, {}", method.alias, method.methodName, method.klass, method.classifications);
            method.register(interpreter);
        }
    }

    private static boolean classificationsAllowRegistering(ExtendedInterpreter interpreter, Class<?>[] classifications) {
        Configuration config = interpreter.getConfiguration();
        Integer allowLevel = 0;
        for (Class<?> classification : classifications) {
            String name = classification.getName();
            String allowKey = "allow(" + name + ")";
            String denyKey = "deny(" + name + ")";
            String allowValue = config.getConfigValue(allowKey).orElse(null);
            String denyValue = config.getConfigValue(denyKey).orElse(null);
            allowLevel = allowLevel + (MethodRegisterUtility.gIV(allowValue) - MethodRegisterUtility.gIV(denyValue));
        }
        return allowLevel >= 0;
    }

    private static Integer gIV(String s) {
        return s == null ? 0 : Integer.valueOf(s);
    }

    static class FunctionLoadParameters {
        Class<?> klass;
        String methodName;
        String alias;
        Class<?>[] parameterTypes;
        BasicFunction annotation;
        Class<?>[] classifications;

        FunctionLoadParameters() {
        }

        void initParameters(Method method, Class<?> klassPar) {
            this.klass = klassPar;
            this.methodName = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.annotation = method.getAnnotation(BasicFunction.class);
        }

        void setAlias() {
            this.alias = this.annotation.alias();
            if (this.alias.length() == 0) {
                this.alias = this.methodName;
            }
        }

        void setMethodName() {
            if (this.annotation.substituteMethod().length() > 0) {
                this.methodName = this.annotation.substituteMethod();
            }
        }

        void setClass() {
            if (this.annotation.substituteClass() != BasicFunction.class) {
                this.klass = this.annotation.substituteClass();
            }
        }

        void setClassification() {
            this.classifications = this.annotation.classification();
            if (this.classifications.length == 1 && this.classifications[0] == BasicFunction.class) {
                this.classifications = null;
            }
        }

        boolean versionIsCompatible() {
            long requiredVersion = this.annotation.requiredVersion();
            if (this.annotation.requiredVersion() > 2L) {
                LOG.error("The method {} can not be registered, because it requires the interface version {} and the implemented version is {}.", this.methodName, requiredVersion, 2L);
            }
            return requiredVersion <= 2L;
        }

        void register(ExtendedInterpreter interpreter) throws BasicRuntimeException {
            if (this.versionIsCompatible()) {
                if (MethodRegisterUtility.classificationsAllowRegistering(interpreter, this.classifications)) {
                    interpreter.registerJavaMethod(this.alias, this.klass, this.methodName, this.parameterTypes);
                } else {
                    LOG.info("Classification prevents the registration of the method {}", this.methodName);
                }
            }
        }

        boolean isFunctionAnnotated() {
            return this.annotation != null;
        }
    }
}

