/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.NoAccess;
import com.scriptbasic.interfaces.NoAccessProxy;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.NoInstance;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectionUtility {
    private ReflectionUtility() {
        NoInstance.isPossible();
    }

    public static Object invoke(String symbolicName, ExtendedInterpreter interpreter, Method method, Object object, List<RightValue> args) throws BasicRuntimeException {
        Object javaCallResult;
        if (object != null && object instanceof NoAccess) {
            Object target = object instanceof NoAccessProxy ? ((NoAccessProxy)object).target : object;
            throw new BasicRuntimeException("It is not allowed to call  '" + symbolicName + "' on object of class '" + target.getClass().getName());
        }
        interpreter.getHook().beforeCallJavaFunction(method);
        try {
            Object[] argArray = ExpressionUtility.getObjectArray(args, method, interpreter);
            javaCallResult = method.invoke(object, argArray);
            if (javaCallResult instanceof BasicArrayValue) {
                ((BasicArrayValue)javaCallResult).setInterpreter(interpreter);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new BasicRuntimeException("Can not invoke method " + symbolicName, e);
        }
        catch (Exception e) {
            throw new BasicRuntimeException("Invoking method '" + symbolicName + "' throws exception:", e);
        }
        return interpreter.getHook().afterCallJavaFunction(method, javaCallResult);
    }
}

