/*
 * Decompiled with CFR 0.152.
 */
package snlogic;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import snlogic.ISDK;
import snlogic.Utils;

public class VerifyWebHookMiddleware
implements Filter {
    @Autowired
    private ISDK sn;
    @Autowired
    private Utils utils;
    private final String HEADER_KEY = "X-SECURENATIVE";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String payload = req.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        if (Strings.isNullOrEmpty((String)payload)) {
            res.sendError(500, "empty request");
        }
        try {
            String digest = "sha1=" + this.utils.calculateRFC2104HMAC(payload, this.sn.getApiKey());
            String checksum = req.getHeader("X-SECURENATIVE");
            if (checksum == null || digest != checksum) {
                res.sendError(500, "Request body digest did not match ");
            }
        }
        catch (Exception e) {
            System.out.println("Error");
        }
    }

    public void destroy() {
    }
}

