/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.securenative.agent.enums.EventTypes;
import com.securenative.agent.events.Agent;
import com.securenative.agent.events.Event;
import com.securenative.agent.events.Framework;
import com.securenative.agent.events.Os;
import com.securenative.agent.events.SnProcess;
import com.securenative.agent.events.SnRuntime;
import com.securenative.agent.snpackage.PackageItem;
import com.securenative.agent.snpackage.PackageManager;
import com.securenative.agent.utils.DateUtils;
import com.securenative.agent.utils.Utils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.logging.Logger;

public class AgentLoginEvent
implements Event {
    private static final String PACKAGE_FILE_NAME = "pom.xml";
    private static final Logger logger = Logger.getLogger(AgentLoginEvent.class.getName());
    @JsonProperty(value="eventType")
    private final String eventType;
    @JsonProperty(value="timestamp")
    private String timestamp;
    @JsonProperty(value="package")
    private PackageItem packageItem;
    @JsonProperty(value="appName")
    private String appName;
    @JsonProperty(value="process")
    private SnProcess process;
    @JsonProperty(value="runtime")
    private SnRuntime snRuntime;
    @JsonProperty(value="os")
    private Os os;
    @JsonProperty(value="framework")
    private Framework framework;
    @JsonProperty(value="agent")
    private Agent agent;

    public AgentLoginEvent(String framework, String frameworkVersion, String appName) {
        String cwd = System.getProperty("user.dir");
        PackageItem appPkg = PackageManager.getPackage(String.join((CharSequence)cwd, PACKAGE_FILE_NAME));
        PackageItem agentPkg = PackageManager.getPackage(String.join((CharSequence)"/sdk-base/", PACKAGE_FILE_NAME));
        this.appName = appName;
        this.framework = new Framework(framework, frameworkVersion);
        this.packageItem = new PackageItem(appPkg.getName(), appPkg.getVersion(), appPkg.getDependencies(), appPkg.getDependenciesHash());
        this.eventType = EventTypes.AGENT_LOG_IN.getType();
        this.snRuntime = new SnRuntime("java", System.getProperty("java.version"));
        AbstractMap.SimpleEntry<Long, String> processInfo = Utils.getProcessInfo();
        this.process = new SnProcess(processInfo.getKey(), processInfo.getValue(), System.getProperty("user.dir"));
        String hostId = null;
        String hostname = null;
        try {
            hostId = InetAddress.getLocalHost().getHostAddress();
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.fine(String.join((CharSequence)"Could not find hostname and/or host address; ", e.toString()));
        }
        this.os = new Os(hostId, hostname, System.getProperty("os.arch"), System.getProperty("os.name"), Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().totalMemory());
        this.agent = new Agent("Server Agent", agentPkg.getVersion(), System.getProperty("java.class.path"));
        this.timestamp = DateUtils.generateTimestamp();
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    public PackageItem getPackageItem() {
        return this.packageItem;
    }

    public String getAppName() {
        return this.appName;
    }

    public SnProcess getProcess() {
        return this.process;
    }

    public SnRuntime getSnRuntime() {
        return this.snRuntime;
    }

    public Os getOs() {
        return this.os;
    }

    public Framework getFramework() {
        return this.framework;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public void setPackageItem(PackageItem packageItem) {
        this.packageItem = packageItem;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setProcess(SnProcess process) {
        this.process = process;
    }

    public void setSnRuntime(SnRuntime snRuntime) {
        this.snRuntime = snRuntime;
    }

    public void setOs(Os os) {
        this.os = os;
    }

    public void setFramework(Framework framework) {
        this.framework = framework;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }
}

