/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.devutil;

import com.simiacryptus.devutil.SimpleMavenProject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Javadoc {
    private static final Logger logger = LoggerFactory.getLogger(Javadoc.class);

    public static HashMap<String, TreeMap<String, String>> loadModelSummary() {
        try {
            return Javadoc.loadModelSummary(SimpleMavenProject.loadProject());
        }
        catch (IOException | DependencyResolutionException | ProjectBuildingException | PlexusContainerException | ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static HashMap<String, TreeMap<String, String>> loadModelSummary(HashMap<String, CompilationUnit> project) {
        final HashMap<String, TreeMap<String, String>> projectData = new HashMap<String, TreeMap<String, String>>();
        project.forEach((file, ast) -> ast.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                TreeMap<String, String> classData = new TreeMap<String, String>();
                org.eclipse.jdt.core.dom.Javadoc javadoc = node.getJavadoc();
                if (null != javadoc) {
                    classData.put(":class", Javadoc.toString(javadoc));
                }
                Arrays.stream(node.getFields()).forEach(declaration -> {
                    org.eclipse.jdt.core.dom.Javadoc fieldJavadoc = declaration.getJavadoc();
                    if (0 != (declaration.getModifiers() & 8)) {
                        return;
                    }
                    if (0 != (declaration.getModifiers() & 0x10)) {
                        return;
                    }
                    List fragments = declaration.fragments();
                    for (VariableDeclarationFragment fragment : fragments) {
                        String key = fragment.getName().getFullyQualifiedName();
                        if (null == fieldJavadoc) continue;
                        classData.put(key, Javadoc.toString(fieldJavadoc));
                    }
                });
                Arrays.stream(node.getMethods()).forEach(declaration -> {
                    org.eclipse.jdt.core.dom.Javadoc methodJavadoc = declaration.getJavadoc();
                    if (0 != (declaration.getModifiers() & 8)) {
                        return;
                    }
                    if (declaration.isConstructor()) {
                        return;
                    }
                    String identifier = declaration.getName().getIdentifier();
                    if (!identifier.startsWith("set") || identifier.length() <= 3 || identifier.substring(3, 4) == identifier.substring(3, 4).toLowerCase() || declaration.parameters().size() != 1) {
                        return;
                    }
                    identifier = identifier.substring(3, 4).toLowerCase() + identifier.substring(4);
                    if (null != methodJavadoc) {
                        classData.put(identifier, Javadoc.toString(methodJavadoc));
                    }
                });
                projectData.put(node.resolveBinding().getQualifiedName(), classData);
                return super.visit(node);
            }
        }));
        return projectData;
    }

    @Nonnull
    public static String toString(org.eclipse.jdt.core.dom.Javadoc javadoc) {
        String trim = javadoc.toString().trim();
        if (!trim.startsWith("/*")) {
            throw new IllegalArgumentException(trim);
        }
        if (!trim.endsWith("*/")) {
            throw new IllegalArgumentException(trim);
        }
        return Arrays.stream(trim.split("\n")).map(x -> x.trim().replaceAll("^/?\\** ?", "").replaceAll("\\**/$", "")).filter(x -> !x.isEmpty()).filter(x -> !x.trim().startsWith("@")).reduce((a, b) -> a + "\n" + b).get();
    }
}

