/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.devutil;

import com.google.inject.Module;
import com.simiacryptus.devutil.BasicModule;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMavenProject {
    private static final File repositoryLocation = new File(System.getProperty("user.home"), ".m2/repository");
    private static final Logger logger = LoggerFactory.getLogger(SimpleMavenProject.class);
    public final DefaultPlexusContainer container;
    public final DefaultRepositorySystemSession session;
    public final MavenProject project;
    public final String projectRoot;

    public SimpleMavenProject(String projectRoot) throws IOException, PlexusContainerException, ComponentLookupException, ProjectBuildingException {
        this.projectRoot = projectRoot;
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", "Maven+SimiaCryptus");
        configProps.put("aether.interactive", false);
        configProps.putAll(System.getProperties());
        this.container = this.getPlexusContainer(repositoryLocation);
        this.session = this.getSession(repositoryLocation, false, configProps, this.container);
        this.project = this.getMavenProject(this.container, this.session);
    }

    public static void main(String[] args) throws Exception {
        String root = args.length == 0 ? "H:\\SimiaCryptus\\MindsEye" : args[0];
        SimpleMavenProject mavenProject = new SimpleMavenProject(root);
        mavenProject.resolve().getDependencies().forEach(dependency -> logger.info(String.format("Dependency: %s (%s)", dependency.getArtifact().getFile().getAbsolutePath(), dependency)));
        HashMap<String, CompilationUnit> parsedFiles = mavenProject.parse();
        parsedFiles.forEach((file, ast) -> {
            logger.info("File: " + file);
            Arrays.stream(ast.getProblems()).forEach(problem -> logger.warn("  ERR: " + problem.getMessage()));
            Arrays.stream(ast.getMessages()).forEach(problem -> logger.info("  MSG: " + problem.getMessage()));
            ast.accept(new ASTVisitor(){
                String indent = "  ";
                Stack stack = new Stack();

                public void preVisit(ASTNode node) {
                    this.indent = this.indent + "  ";
                    if (node instanceof Name) {
                        Name name = (Name)node;
                        IBinding binding = name.resolveBinding();
                        String bindingString = binding == null ? "???" : (binding instanceof ITypeBinding ? ((ITypeBinding)binding).getBinaryName() : binding.toString());
                        logger.info(String.format("  %s%s%s = %s (%s: %s)", node.getStartPosition(), this.indent, node.getClass().getSimpleName(), name.getFullyQualifiedName(), null == binding ? null : binding.getClass().getSimpleName(), bindingString));
                    } else {
                        logger.info(String.format("  %s%s%s", node.getStartPosition(), this.indent, node.getClass().getSimpleName()));
                    }
                    this.stack.push(node);
                }

                public void postVisit(ASTNode node) {
                    if (node != this.stack.pop()) {
                        throw new IllegalStateException();
                    }
                    if (this.indent.length() < 2) {
                        throw new IllegalStateException();
                    }
                    this.indent = this.indent.substring(2);
                }
            });
        });
    }

    public static HashMap<String, CompilationUnit> loadProject() throws IOException, PlexusContainerException, ComponentLookupException, ProjectBuildingException, DependencyResolutionException {
        return SimpleMavenProject.loadProject(new File(".").getAbsolutePath());
    }

    public static HashMap<String, CompilationUnit> loadProject(String root) throws IOException, PlexusContainerException, ComponentLookupException, ProjectBuildingException, DependencyResolutionException {
        SimpleMavenProject mavenProject = new SimpleMavenProject(root);
        mavenProject.resolve().getDependencies().forEach(dependency -> logger.info(String.format("Dependency: %s (%s)", dependency.getArtifact().getFile().getAbsolutePath(), dependency)));
        return mavenProject.parse();
    }

    public final HashMap<String, CompilationUnit> parse() throws ComponentLookupException, DependencyResolutionException {
        String root = this.projectRoot;
        ASTParser astParser = ASTParser.newParser((int)9);
        astParser.setKind(1);
        astParser.setResolveBindings(true);
        HashMap<String, String> compilerOptions = new HashMap<String, String>();
        compilerOptions.put("org.eclipse.jdt.core.compiler.source", CompilerOptions.versionFromJdkLevel((long)0x340000L));
        compilerOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        astParser.setCompilerOptions(compilerOptions);
        String[] classpathEntries = (String[])this.resolve().getDependencies().stream().map(x -> x.getArtifact().getFile().getAbsolutePath()).toArray(String[]::new);
        String[] sourcepathEntries = (String[])Stream.concat(this.project.getTestCompileSourceRoots().stream(), this.project.getCompileSourceRoots().stream()).toArray(String[]::new);
        astParser.setEnvironment(classpathEntries, sourcepathEntries, null, true);
        final HashMap<String, CompilationUnit> results = new HashMap<String, CompilationUnit>();
        astParser.createASTs((String[])FileUtils.listFiles((File)new File(root), (String[])new String[]{"java"}, (boolean)true).stream().map(x -> x.getAbsolutePath()).toArray(String[]::new), null, new String[0], new FileASTRequestor(){

            public void acceptAST(String source, CompilationUnit ast) {
                results.put(source, ast);
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return results;
    }

    public DependencyResolutionResult resolve() throws ComponentLookupException, DependencyResolutionException {
        return ((ProjectDependenciesResolver)this.container.lookup(ProjectDependenciesResolver.class)).resolve(new DefaultDependencyResolutionRequest().setRepositorySession((RepositorySystemSession)this.session).setMavenProject(this.project));
    }

    private MavenProject getMavenProject(DefaultPlexusContainer container, DefaultRepositorySystemSession session) throws ProjectBuildingException, ComponentLookupException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setRepositorySession((RepositorySystemSession)session);
        return ((ProjectBuilder)container.lookup(ProjectBuilder.class)).build(new File(this.projectRoot, "pom.xml"), (ProjectBuildingRequest)request).getProject();
    }

    @Nonnull
    private DefaultRepositorySystemSession getSession(File repositoryLocation, boolean isOffline, Map<Object, Object> configProps, DefaultPlexusContainer container) throws ComponentLookupException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setConfigProperties(configProps);
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        session.setOffline(isOffline);
        session.setUpdatePolicy("always");
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(1, 1));
        session.setArtifactTypeRegistry(RepositoryUtils.newArtifactTypeRegistry((ArtifactHandlerManager)((ArtifactHandlerManager)container.lookup(ArtifactHandlerManager.class))));
        session.setLocalRepositoryManager(((DefaultRepositorySystem)container.lookup(DefaultRepositorySystem.class)).newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(repositoryLocation)));
        return session;
    }

    @Nonnull
    private DefaultPlexusContainer getPlexusContainer(File repositoryLocation) throws IOException, PlexusContainerException {
        DefaultRepositoryLayout defaultRepositoryLayout = new DefaultRepositoryLayout();
        ArtifactRepositoryPolicy repositoryPolicy = new ArtifactRepositoryPolicy(true, "never", "warn");
        String url = "file://" + repositoryLocation.getCanonicalPath();
        MavenArtifactRepository repository = new MavenArtifactRepository("central", url, (ArtifactRepositoryLayout)defaultRepositoryLayout, repositoryPolicy, repositoryPolicy);
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ContainerConfiguration configuration = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classWorld.getClassRealm(null)).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName("maven");
        return new DefaultPlexusContainer(configuration, new Module[]{new BasicModule((ArtifactRepository)repository)});
    }
}

