/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.devutil;

import com.simiacryptus.devutil.SimpleMavenProject;
import java.util.Arrays;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyScanner {
    private static final Logger logger = LoggerFactory.getLogger(DependencyScanner.class);

    public static void main(@Nonnull String[] args) throws Exception {
        String root = args.length == 0 ? "H:\\SimiaCryptus\\MindsEye" : args[0];
        SimpleMavenProject.loadProject(root).forEach((file, ast) -> {
            logger.info("File: " + file);
            DependencyScanner.logTree(ast);
        });
    }

    public static void logTree(@Nonnull CompilationUnit ast) {
        Arrays.stream(ast.getProblems()).forEach(problem -> logger.warn("  ERR: " + problem.getMessage()));
        Arrays.stream(ast.getMessages()).forEach(problem -> logger.info("  MSG: " + problem.getMessage()));
        ast.accept(new ASTVisitor(){
            public boolean useJavaDoc = false;
            @Nonnull String indent = "  ";
            @Nonnull Stack<ASTNode> stack = new Stack();
            String currentCodeContext = "";

            public void preVisit(ASTNode node) {
                this.indent = this.indent + "  ";
                if (node instanceof Name) {
                    Name name = (Name)node;
                    IBinding binding = name.resolveBinding();
                    String bindingString = binding == null ? "???" : (binding instanceof ITypeBinding ? ((ITypeBinding)binding).getBinaryName() : binding.toString());
                    logger.debug(String.format("  %s%s%s = %s (%s: %s)", node.getStartPosition(), this.indent, node.getClass().getSimpleName(), name.getFullyQualifiedName(), null == binding ? null : binding.getClass().getSimpleName(), bindingString));
                } else {
                    logger.debug(String.format("  %s%s%s", node.getStartPosition(), this.indent, node.getClass().getSimpleName()));
                }
                this.stack.push(node);
            }

            public void postVisit(ASTNode node) {
                if (node != this.stack.pop()) {
                    throw new IllegalStateException();
                }
                if (this.indent.length() < 2) {
                    throw new IllegalStateException();
                }
                this.indent = this.indent.substring(2);
            }

            public boolean visit(@Nonnull SimpleName node) {
                IVariableBinding variableBinding;
                String ref;
                IBinding binding = node.resolveBinding();
                if (binding instanceof IMethodBinding) {
                    if (!(node.getParent() instanceof MethodDeclaration)) {
                        String ref2 = DependencyScanner.toStringMethod((IMethodBinding)binding);
                        logger.info(String.format("   Ref %s", ref2));
                    }
                } else if (binding instanceof IVariableBinding && null != (ref = DependencyScanner.toStringVar(variableBinding = (IVariableBinding)binding))) {
                    logger.info(String.format("   Ref %s", ref));
                }
                return super.visit(node);
            }

            public boolean visit(@Nonnull ConstructorInvocation node) {
                IMethodBinding binding = node.resolveConstructorBinding();
                String ref = DependencyScanner.toStringMethod(binding);
                logger.info(String.format("   Ref %s", ref));
                return super.visit(node);
            }

            public boolean visit(@Nonnull SuperConstructorInvocation node) {
                IMethodBinding binding = node.resolveConstructorBinding();
                String ref = DependencyScanner.toStringMethod(binding);
                logger.info(String.format("   Ref %s", ref));
                return super.visit(node);
            }

            public boolean visit(@Nonnull VariableDeclarationFragment node) {
                Optional<ASTNode> fieldDeclaration = this.stack.stream().filter(x -> x instanceof FieldDeclaration).findAny();
                if (fieldDeclaration.isPresent()) {
                    Javadoc javadoc = ((FieldDeclaration)fieldDeclaration.get()).getJavadoc();
                    IVariableBinding variableBinding = node.resolveBinding();
                    if (null == variableBinding) {
                        logger.info(String.format("  UNRESOLVED Field %s", node));
                    } else {
                        ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                        this.currentCodeContext = String.format("%s::%s", null == declaringClass ? null : declaringClass.getBinaryName(), variableBinding.getName());
                        logger.info(String.format("  Field %s %s", this.currentCodeContext, (!this.useJavaDoc || null == javadoc ? node : javadoc).toString().replaceAll("\n", "\n    ").trim()));
                    }
                }
                return super.visit(node);
            }

            public boolean visit(@Nonnull MethodDeclaration node) {
                Javadoc javadoc = node.getJavadoc();
                IMethodBinding methodBinding = node.resolveBinding();
                this.currentCodeContext = DependencyScanner.toStringMethod(methodBinding);
                logger.info(String.format("  Method %s %s", this.currentCodeContext, (!this.useJavaDoc || null == javadoc ? node : javadoc).toString().replaceAll("\n", "\n    ").trim()));
                return super.visit(node);
            }
        });
    }

    private static String toStringMethod(@Nullable IMethodBinding methodBinding) {
        String symbolStr;
        if (null != methodBinding) {
            ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
            String params = null == parameterTypes ? "null" : Arrays.stream(parameterTypes).map(x -> DependencyScanner.toStringType(x)).map(x -> null == x ? "null" : x).reduce((a, b) -> a + "," + b).orElse("");
            String name = methodBinding.getDeclaringClass().getBinaryName() + "::" + methodBinding.getName();
            symbolStr = String.format("%s(%s)", name, params);
        } else {
            symbolStr = "???";
        }
        return symbolStr;
    }

    private static String toStringType(@Nullable ITypeBinding x) {
        if (null == x) {
            return "null";
        }
        if (x.isPrimitive()) {
            return x.getName();
        }
        if (x.isArray()) {
            return DependencyScanner.toStringType(x.getElementType()) + "[]";
        }
        return x.getBinaryName();
    }

    private static @Nullable String toStringVar(@Nullable IVariableBinding iVariableBinding) {
        if (null == iVariableBinding) {
            return null;
        }
        ITypeBinding declaringClass = iVariableBinding.getDeclaringClass();
        if (null == declaringClass) {
            return null;
        }
        return declaringClass.getBinaryName() + "::" + iVariableBinding.getName();
    }
}

