/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.CompressionUtil;
import com.simiacryptus.util.text.TrieNode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TextGenerator {
    private final CharTrie inner;

    TextGenerator(CharTrie inner) {
        this.inner = inner;
    }

    public String generateMarkov(int length, int context, String seed) {
        String str = seed;
        while (str.length() < length) {
            String prefix = str.substring(Math.max(str.length() - context, 0), str.length());
            TrieNode node = this.inner.matchPredictor(prefix);
            long cursorCount = node.getCursorCount();
            long fate = CompressionUtil.random.nextLong() % cursorCount;
            String next = null;
            Stream<TrieNode> stream = node.getChildren().map(x -> x);
            List children = stream.collect(Collectors.toList());
            for (TrieNode child : children) {
                if ((fate -= child.getCursorCount()) > 0L) continue;
                if (child.getChar() == '\u0000') break;
                next = child.getToken();
                break;
            }
            if (null == next) break;
            str = str + next;
        }
        return str;
    }

    public String generateDictionary(int length, int context, String seed, int lookahead, boolean destructive) {
        return this.generateDictionary(length, context, seed, lookahead, destructive, false);
    }

    public String generateDictionary(int length, int context, String seed, int lookahead, boolean destructive, boolean terminateAtNull) {
        String str = seed;
        String prefix = "";
        while (str.length() < length) {
            TrieNode nextNode;
            TrieNode node;
            TrieNode trieNode = node = prefix.isEmpty() ? this.inner.root() : this.inner.matchPredictor(prefix);
            if (null == node) {
                prefix = prefix.substring(1);
            }
            if (null == (nextNode = this.maxNextNode(node, lookahead))) break;
            if (destructive) {
                nextNode.removeCursorCount();
            }
            String next = nextNode.getString(node);
            str = str + next;
            prefix = str.substring(Math.max(str.length() - context, 0), str.length());
            if (next.isEmpty()) {
                if (prefix.isEmpty()) break;
                prefix = prefix.substring(1);
            }
            if (nextNode.getChar() != '\u0000') continue;
            if (terminateAtNull) break;
            prefix = "";
        }
        return str.substring(0, Math.min(length, str.length()));
    }

    private Map<Character, Double> lookahead(TrieNode node, double smoothness) {
        HashMap<Character, Double> map = new HashMap<Character, Double>();
        this.lookahead(node, map, 1.0, smoothness);
        return map;
    }

    private void lookahead(TrieNode node, HashMap<Character, Double> map, double factor, double smoothness) {
        if (0.0 < factor) {
            node.getChildren().forEach(child -> map.put(Character.valueOf(child.getChar()), factor * (double)child.getCursorCount() + map.getOrDefault(child.getToken(), 0.0)));
            if (null != node.getParent()) {
                this.lookahead(this.inner.matchPredictor(node.getString().substring(1)), map, factor * (smoothness / (smoothness + (double)node.getCursorCount())), smoothness);
            }
        }
    }

    private TrieNode maxNextNode(TrieNode node, int lookahead) {
        Stream<TrieNode> childStream = node.getChildren().map(x -> x);
        for (int level = 0; level < lookahead; ++level) {
            childStream = childStream.flatMap(child -> child.hasChildren() ? child.getChildren() : Stream.of(child));
        }
        TrieNode result = childStream.max(Comparator.comparingLong(x -> x.getCursorCount())).orElse(null);
        if (null == result) {
            if (lookahead > 0) {
                return this.maxNextNode(node, lookahead - 1);
            }
            TrieNode godparent = node.godparent();
            if (null != godparent) {
                return this.maxNextNode(godparent, lookahead);
            }
        }
        return result;
    }
}

