/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import java.util.DoubleSummaryStatistics;
import java.util.stream.Collector;

public class DoubleStatistics
extends DoubleSummaryStatistics {
    public static Collector<Double, DoubleStatistics, DoubleStatistics> COLLECTOR = Collector.of(DoubleStatistics::new, DoubleStatistics::accept, DoubleStatistics::combine, d -> d, new Collector.Characteristics[0]);
    public static Collector<Number, DoubleStatistics, DoubleStatistics> NUMBERS = Collector.of(DoubleStatistics::new, (a, n) -> a.accept(n.doubleValue()), DoubleStatistics::combine, d -> d, new Collector.Characteristics[0]);
    private double sumOfSquare = 0.0;
    private double sumOfSquareCompensation;
    private double simpleSumOfSquare;

    @Override
    public void accept(double value) {
        super.accept(value);
        double squareValue = value * value;
        this.simpleSumOfSquare += squareValue;
        this.sumOfSquareWithCompensation(squareValue);
    }

    public DoubleStatistics combine(DoubleStatistics other) {
        super.combine(other);
        this.simpleSumOfSquare += other.simpleSumOfSquare;
        this.sumOfSquareWithCompensation(other.sumOfSquare);
        this.sumOfSquareWithCompensation(other.sumOfSquareCompensation);
        return this;
    }

    private void sumOfSquareWithCompensation(double value) {
        double tmp = value - this.sumOfSquareCompensation;
        double velvel = this.sumOfSquare + tmp;
        this.sumOfSquareCompensation = velvel - this.sumOfSquare - tmp;
        this.sumOfSquare = velvel;
    }

    public double getSumOfSquare() {
        double tmp = this.sumOfSquare + this.sumOfSquareCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSumOfSquare)) {
            return this.simpleSumOfSquare;
        }
        return tmp;
    }

    public final double getStandardDeviation() {
        return this.getCount() > 0L ? Math.sqrt(this.getSumOfSquare() / (double)this.getCount() - Math.pow(this.getAverage(), 2.0)) : 0.0;
    }
}

