/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.test;

import com.simiacryptus.util.test.AsyncListIterator;
import com.simiacryptus.util.test.Spool;
import com.simiacryptus.util.test.TestDocument;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.utils.IOUtils;

public class Misspelling
extends TestDocument {
    public static Loader BIRKBECK = new Loader(URI.create("http://www.dcs.bbk.ac.uk/~ROGER/missp.dat"), 10000);

    public Misspelling(String correct, String misspelling) {
        super(correct, misspelling);
    }

    public static class Loader {
        private final String url;
        private final String file;
        private final int articleLimit;
        private volatile Thread thread;
        private final List<Misspelling> queue = Collections.synchronizedList(new ArrayList());

        public Loader(URI uri, int articleLimit) {
            this.url = uri.toString();
            this.articleLimit = articleLimit;
            String path = uri.getPath();
            String[] split = path.split("/");
            this.file = split[split.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void clear() throws InterruptedException {
            if (this.thread == null) return;
            Class<Misspelling> clazz = Misspelling.class;
            synchronized (Misspelling.class) {
                if (this.thread == null) return;
                this.thread.interrupt();
                this.thread.join();
                this.thread = null;
                this.queue.clear();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Stream<Misspelling> load() {
            if (this.thread == null) {
                Class<Misspelling> clazz = Misspelling.class;
                // MONITORENTER : com.simiacryptus.util.test.Misspelling.class
                if (this.thread == null) {
                    this.thread = new Thread(this::read);
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
                // MONITOREXIT : clazz
            }
            AsyncListIterator<Misspelling> iterator = new AsyncListIterator<Misspelling>(this.queue, this.thread);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1), false).filter(x -> x != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read() {
            try (InputStream in = Spool.load(this.url, this.file);){
                String txt = new String(IOUtils.toByteArray((InputStream)in), "UTF-8").replaceAll("\r", "");
                List<String> list = Arrays.asList(txt.split("\n"));
                String activeItem = "";
                for (String item : list) {
                    if (item.startsWith("$")) {
                        activeItem = item.substring(1);
                        continue;
                    }
                    this.queue.add(new Misspelling(activeItem, item));
                }
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof InterruptedException)) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                System.err.println("Read thread exit");
            }
        }
    }
}

