/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.google.common.collect.Iterators;
import com.simiacryptus.util.data.SerialArrayList;
import com.simiacryptus.util.text.CharTrieIndex;
import com.simiacryptus.util.text.NodeData;
import com.simiacryptus.util.text.NodeType;
import com.simiacryptus.util.text.NodewalkerCodec;
import com.simiacryptus.util.text.TextAnalysis;
import com.simiacryptus.util.text.TextGenerator;
import com.simiacryptus.util.text.TrieNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CharTrie {
    protected final SerialArrayList<NodeData> nodes;
    protected int[] parentIndex = null;
    protected int[] godparentIndex = null;

    public CharTrie(SerialArrayList<NodeData> nodes) {
        this.nodes = nodes;
    }

    public CharTrie() {
        this(new SerialArrayList<NodeData>(NodeType.INSTANCE, new NodeData('\u0000', -1, -1, -1L, 0L)));
    }

    public CharTrie(CharTrie charTrie) {
        this(charTrie.nodes.copy());
        this.parentIndex = null == charTrie.parentIndex ? null : Arrays.copyOf(charTrie.parentIndex, charTrie.parentIndex.length);
        this.godparentIndex = null == charTrie.godparentIndex ? null : Arrays.copyOf(charTrie.godparentIndex, charTrie.godparentIndex.length);
    }

    public TrieNode root() {
        return new TrieNode(this, 0, null);
    }

    synchronized void ensureParentIndexCapacity(int start, int length, int parentId) {
        int newLength;
        int end = start + length;
        if (null == this.parentIndex) {
            this.parentIndex = new int[end];
            Arrays.fill(this.parentIndex, parentId);
        } else {
            for (newLength = this.parentIndex.length; newLength < end; newLength *= 2) {
            }
            if (newLength > this.parentIndex.length) {
                this.parentIndex = Arrays.copyOfRange(this.parentIndex, 0, newLength);
                Arrays.fill(this.parentIndex, end, newLength, -1);
            }
            Arrays.fill(this.parentIndex, start, end, parentId);
        }
        if (null == this.godparentIndex) {
            this.godparentIndex = new int[end];
            Arrays.fill(this.godparentIndex, -1);
        } else {
            for (newLength = this.godparentIndex.length; newLength < end; newLength *= 2) {
            }
            if (newLength > this.godparentIndex.length) {
                int prevLength = this.godparentIndex.length;
                this.godparentIndex = Arrays.copyOfRange(this.godparentIndex, 0, newLength);
                Arrays.fill(this.godparentIndex, prevLength, newLength, -1);
            }
        }
    }

    public CharTrie reverse() {
        CharTrieIndex result = new CharTrieIndex();
        TreeMap<Character, ? extends TrieNode> childrenMap = this.root().getChildrenMap();
        this.reverseSubtree(childrenMap, ((CharTrie)result).root());
        return ((CharTrie)result).recomputeCursorDetails();
    }

    private void reverseSubtree(TreeMap<Character, ? extends TrieNode> childrenMap, TrieNode destination) {
        String suffix = new StringBuilder(destination.getRawString()).reverse().toString();
        TreeMap<Character, Long> children = new TreeMap<Character, Long>();
        childrenMap.forEach((token, node) -> {
            TrieNode analog = node.traverse(suffix);
            boolean found = (token + suffix).equals(analog.getRawString());
            if (found) {
                children.put((Character)token, analog.getCursorCount());
            }
        });
        destination.writeChildren(children);
        destination.getChildren().forEach(child -> this.reverseSubtree(childrenMap, (TrieNode)child));
    }

    public CharTrie rewrite(BiFunction<TrieNode, Map<Character, TrieNode>, TreeMap<Character, Long>> fn) {
        CharTrieIndex result = new CharTrieIndex();
        this.rewriteSubtree(this.root(), ((CharTrie)result).root(), fn);
        return ((CharTrie)result).recomputeCursorDetails();
    }

    private void rewriteSubtree(TrieNode sourceNode, TrieNode destNode, BiFunction<TrieNode, Map<Character, TrieNode>, TreeMap<Character, Long>> fn) {
        CharTrie result = destNode.getTrie();
        TreeMap<Character, ? extends TrieNode> sourceChildren = sourceNode.getChildrenMap();
        TreeMap<Character, Long> newCounts = fn.apply(sourceNode, sourceChildren);
        destNode.writeChildren(newCounts);
        TreeMap<Character, ? extends TrieNode> newChildren = destNode.getChildrenMap();
        newCounts.keySet().forEach(key -> {
            if (sourceChildren.containsKey(key)) {
                this.rewriteSubtree((TrieNode)sourceChildren.get(key), (TrieNode)newChildren.get(key), fn);
            }
        });
    }

    public static BiFunction<CharTrie, CharTrie, CharTrie> reducer(BiFunction<TrieNode, TrieNode, TreeMap<Character, Long>> fn) {
        return (left, right) -> left.reduce((CharTrie)right, fn);
    }

    public CharTrie add(CharTrie z) {
        return this.reduceSimple(z, (left, right) -> (null == left ? 0L : left) + (null == right ? 0L : right));
    }

    public CharTrie product(CharTrie z) {
        return this.reduceSimple(z, (left, right) -> (null == left ? 0L : left) * (null == right ? 0L : right));
    }

    public CharTrie divide(CharTrie z, int factor) {
        return this.reduceSimple(z, (left, right) -> null == right ? 0L : (null == left ? 0L : left) * (long)factor / right);
    }

    public CharTrie reduceSimple(CharTrie z, BiFunction<Long, Long, Long> fn) {
        return this.reduce(z, (left, right) -> {
            TreeMap<Character, ? extends TrieNode> leftChildren = null == left ? new TreeMap<Character, TrieNode>() : left.getChildrenMap();
            TreeMap<Character, ? extends TrieNode> rightChildren = null == right ? new TreeMap<Character, TrieNode>() : right.getChildrenMap();
            Map<Character, Long> map = Stream.of(rightChildren.keySet(), leftChildren.keySet()).flatMap(x -> x.stream()).distinct().collect(Collectors.toMap(c -> c, c -> {
                assert (null != leftChildren);
                assert (null != rightChildren);
                assert (null != c);
                TrieNode leftChild = (TrieNode)leftChildren.get(c);
                Long l = null == leftChild ? null : Long.valueOf(leftChild.getCursorCount());
                TrieNode rightChild = (TrieNode)rightChildren.get(c);
                Long r = null == rightChild ? null : Long.valueOf(rightChild.getCursorCount());
                return (Long)fn.apply(l, r);
            }));
            return new TreeMap<Character, Long>(map);
        });
    }

    public CharTrie reduce(CharTrie right, BiFunction<TrieNode, TrieNode, TreeMap<Character, Long>> fn) {
        CharTrieIndex result = new CharTrieIndex();
        this.reduceSubtree(this.root(), right.root(), ((CharTrie)result).root(), fn);
        return ((CharTrie)result).recomputeCursorDetails();
    }

    CharTrie recomputeCursorDetails() {
        this.godparentIndex = new int[this.getNodeCount()];
        this.parentIndex = new int[this.getNodeCount()];
        Arrays.fill(this.godparentIndex, 0, this.godparentIndex.length, -1);
        Arrays.fill(this.parentIndex, 0, this.parentIndex.length, -1);
        System.gc();
        this.recomputeCursorTotals(this.root());
        System.gc();
        this.recomputeCursorPositions(this.root(), 0);
        System.gc();
        return this;
    }

    private NodeData recomputeCursorTotals(TrieNode node) {
        this.parentIndex[node.index] = null == node.getParent() ? -1 : node.getParent().index;
        List newChildren = node.getChildren().map(child -> this.recomputeCursorTotals((TrieNode)child)).collect(Collectors.toList());
        if (newChildren.isEmpty()) {
            return node.getData();
        }
        long cursorCount = newChildren.stream().mapToLong(n -> n.cursorCount).sum();
        assert (0L < cursorCount);
        return node.update(d -> d.setCursorCount(cursorCount));
    }

    private void recomputeCursorPositions(TrieNode node, int position) {
        node.update(n -> n.setFirstCursorIndex(position));
        int childPosition = position;
        Stream<TrieNode> stream = node.getChildren().map(x -> x);
        for (TrieNode child : stream.collect(Collectors.toList())) {
            this.recomputeCursorPositions(child, childPosition);
            childPosition = (int)((long)childPosition + child.getCursorCount());
        }
    }

    private void reduceSubtree(TrieNode sourceNodeA, TrieNode sourceNodeB, TrieNode destNode, BiFunction<TrieNode, TrieNode, TreeMap<Character, Long>> fn) {
        destNode.writeChildren(fn.apply(sourceNodeA, sourceNodeB));
        TreeMap<Character, ? extends TrieNode> sourceChildrenA = null == sourceNodeA ? null : sourceNodeA.getChildrenMap();
        TreeMap<Character, ? extends TrieNode> sourceChildrenB = null == sourceNodeB ? null : sourceNodeB.getChildrenMap();
        destNode.getChildrenMap().forEach((key, newChild) -> {
            boolean containsB;
            boolean containsA = null == sourceChildrenA ? false : sourceChildrenA.containsKey(key);
            boolean bl = containsB = null == sourceChildrenB ? false : sourceChildrenB.containsKey(key);
            if (containsA && containsB) {
                this.reduceSubtree((TrieNode)sourceChildrenA.get(key), (TrieNode)sourceChildrenB.get(key), (TrieNode)newChild, fn);
            } else if (containsA) {
                this.reduceSubtree((TrieNode)sourceChildrenA.get(key), null, (TrieNode)newChild, fn);
            } else if (containsB) {
                this.reduceSubtree(null, (TrieNode)sourceChildrenB.get(key), (TrieNode)newChild, fn);
            }
        });
    }

    public TrieNode traverse(String search) {
        return this.root().traverse(search);
    }

    public int getNodeCount() {
        return this.nodes.length();
    }

    public TrieNode matchEnd(String search) {
        if (search.isEmpty()) {
            return this.root();
        }
        int min = 0;
        int max = search.length();
        int i = Math.min(max, 12);
        int winner = -1;
        while (max > min) {
            String attempt = search.substring(search.length() - i);
            TrieNode cursor = this.traverse(attempt);
            if (cursor.getString().equals(attempt)) {
                min = Math.max(min, i + 1);
                winner = Math.max(winner, i);
            } else {
                max = Math.min(max, i - 1);
            }
            i = (3 * max + min) / 4;
        }
        if (winner < 0) {
            return this.root();
        }
        String matched = search.substring(search.length() - winner);
        return this.traverse(matched);
    }

    public TrieNode matchPredictor(String search) {
        TrieNode cursor = this.matchEnd(search);
        if (cursor.getNumberOfChildren() > 0) {
            return cursor;
        }
        String string = cursor.getString();
        if (string.isEmpty()) {
            return null;
        }
        return this.matchPredictor(string.substring(1));
    }

    public CharTrie copy() {
        return new CharTrie(this);
    }

    public int getMemorySize() {
        return this.nodes.getMemorySize();
    }

    public long getIndexedSize() {
        return this.nodes.get((int)0).cursorCount;
    }

    public NodewalkerCodec getCodec() {
        return new NodewalkerCodec(this);
    }

    public TextGenerator getGenerator() {
        return new TextGenerator(this.truncate().copy());
    }

    public TextAnalysis getAnalyzer() {
        return new TextAnalysis(this.truncate().copy());
    }

    protected CharTrie truncate() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharTrie charTrie = (CharTrie)o;
        return this.nodes.equals(charTrie.nodes);
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public Set<Character> tokens() {
        return this.root().getChildrenMap().keySet().stream().filter(c -> c.charValue() != '\u0000' && c.charValue() != '\uffff' && c != NodewalkerCodec.ESCAPE).collect(Collectors.toSet());
    }

    public boolean contains(String text) {
        return this.traverse(text).getString().endsWith(text);
    }

    public <T extends Comparable<T>> Stream<TrieNode> max(Function<TrieNode, T> fn, int maxResults) {
        return this.max(fn, maxResults, this.root());
    }

    private <T extends Comparable<T>> Stream<TrieNode> max(Function<TrieNode, T> fn, int maxResults, TrieNode node) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Iterators.mergeSorted((Iterable)Stream.concat(Stream.of(Stream.of(node)), node.getChildren().map(x -> this.max(fn, maxResults, (TrieNode)x))).map(x -> x.iterator()).collect(Collectors.toList()), Comparator.comparing(fn).reversed()), 16), false).limit(maxResults).collect(Collectors.toList()).stream();
    }

    public static <T> Stream<T> toStream(Optional<T> opt) {
        return Arrays.asList(opt.orElse(null)).stream().filter(y -> null != y);
    }
}

