/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.CompressionUtil;
import com.simiacryptus.util.text.ConvolutionalTrieSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.compress.utils.IOUtils;

public enum LanguageModel {
    English("English.trie"),
    French("French.trie"),
    German("German.trie");

    private final String resource;
    private volatile CharTrie trie;

    public static LanguageModel match(String text) {
        return Arrays.stream(LanguageModel.values()).min(Comparator.comparing(model -> model.getTrie().getCodec().encodePPM((String)text, (int)2).bitLength)).get();
    }

    private LanguageModel(String resource) {
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharTrie getTrie() {
        if (null == this.trie) {
            LanguageModel languageModel = this;
            synchronized (languageModel) {
                if (null == this.trie) {
                    byte[] bytes;
                    try {
                        bytes = IOUtils.toByteArray((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resource));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.trie = new ConvolutionalTrieSerializer().deserialize(CompressionUtil.decodeLZ(bytes));
                }
            }
        }
        return this.trie;
    }
}

