/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.text;

import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.binary.Interval;
import com.simiacryptus.util.text.CharTrie;
import com.simiacryptus.util.text.NodeData;
import com.simiacryptus.util.text.NodewalkerCodec;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TrieNode {
    private transient short depth = (short)-1;
    private transient TrieNode parent = null;
    protected final CharTrie trie;
    protected final int index;
    private transient NodeData data;

    public TrieNode(CharTrie trie, int index) {
        assert (0 <= index);
        assert (0 == index || trie.parentIndex[index] >= 0);
        this.trie = trie;
        this.index = index;
    }

    public TrieNode(CharTrie trie, int index, TrieNode parent) {
        assert (0 <= index);
        this.trie = trie;
        this.index = index;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeData getData() {
        if (null == this.data) {
            TrieNode trieNode = this;
            synchronized (trieNode) {
                if (null == this.data) {
                    this.data = this.trie.nodes.get(this.index);
                }
            }
        }
        return this.data;
    }

    public TrieNode godparent() {
        TrieNode greatgodparent;
        int godparentIndex;
        if (0 == this.getDepth()) {
            return null;
        }
        TrieNode root = this.trie.root();
        if (1 == this.getDepth()) {
            return root;
        }
        if (null != this.trie.godparentIndex && this.trie.godparentIndex.length > this.index && (godparentIndex = this.trie.godparentIndex[this.index]) >= 0) {
            return this.newNode(godparentIndex);
        }
        TrieNode parent = this.getParent();
        TrieNode godparent = null == parent ? root : (null == (greatgodparent = parent.godparent()) ? root : greatgodparent.getChild(this.getChar()).map(x -> x).orElseGet(() -> root));
        if (null != godparent && null != this.trie.godparentIndex && this.trie.godparentIndex.length > this.index) {
            this.trie.godparentIndex[this.index] = godparent.index;
        }
        return godparent;
    }

    protected TrieNode newNode(int index) {
        return new TrieNode(this.trie, index);
    }

    public TrieNode refresh() {
        this.data = null;
        return this;
    }

    public String getString(TrieNode root) {
        if (this == root) {
            return "";
        }
        String parentStr = null == this.getParent() ? "" : this.getParent().getString(root);
        return parentStr + this.getToken();
    }

    public String getRawString() {
        return 0 == this.getDepth() ? "" : this.getParent().getRawString() + new String(new char[]{this.getChar()});
    }

    public String getString() {
        return (null == this.getParent() ? "" : this.getParent().getString()) + (0 == this.getDepth() ? "" : this.getToken());
    }

    public String getDebugString() {
        return this.getDebugString(this.getTrie().root());
    }

    public String getDebugString(TrieNode root) {
        if (this == root) {
            return "";
        }
        String parentStr = null == this.getParent() ? "" : this.getParent().getDebugString(root);
        return parentStr + this.getDebugToken();
    }

    public String getDebugToken() {
        char asChar = this.getChar();
        if (asChar == '\uffff') {
            return "<STOP>";
        }
        if (asChar == '\u0000') {
            return "<NULL>";
        }
        if (asChar == NodewalkerCodec.ESCAPE.charValue()) {
            return "<ESC>";
        }
        if (asChar == '\\') {
            return "\\\\";
        }
        if (asChar == '\n') {
            return "\\n";
        }
        return new String(new char[]{asChar});
    }

    public String getToken() {
        char asChar = this.getChar();
        if (asChar == '\uffff') {
            return "";
        }
        if (asChar == '\u0000') {
            return "";
        }
        if (asChar == NodewalkerCodec.ESCAPE.charValue()) {
            return "";
        }
        return new String(new char[]{asChar});
    }

    public char getChar() {
        return this.getData().token;
    }

    public short getNumberOfChildren() {
        return this.getData().numberOfChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getDepth() {
        if (0 == this.index) {
            return 0;
        }
        if (-1 == this.depth) {
            TrieNode trieNode = this;
            synchronized (trieNode) {
                if (-1 == this.depth) {
                    TrieNode parent = this.getParent();
                    assert (null == parent || parent.index < this.index);
                    this.depth = (short)(null == parent ? 0 : parent.getDepth() + 1);
                }
            }
        }
        return this.depth;
    }

    public long getCursorIndex() {
        return this.getData().firstCursorIndex;
    }

    public long getCursorCount() {
        return this.getData().cursorCount;
    }

    public TrieNode visitFirst(Consumer<? super TrieNode> visitor) {
        visitor.accept(this);
        TrieNode refresh = this.refresh();
        refresh.getChildren().forEach(n -> n.visitFirst(visitor));
        return refresh;
    }

    public TrieNode visitLast(Consumer<? super TrieNode> visitor) {
        this.getChildren().forEach(n -> n.visitLast(visitor));
        visitor.accept(this);
        return this.refresh();
    }

    public Stream<? extends TrieNode> getChildren() {
        if (this.getData().firstChildIndex >= 0) {
            return IntStream.range(0, this.getData().numberOfChildren).mapToObj(i -> new TrieNode(this.trie, this.getData().firstChildIndex + i, this));
        }
        return Stream.empty();
    }

    public Optional<? extends TrieNode> getChild(char token) {
        NodeData data = this.getData();
        int min = data.firstChildIndex;
        int max = data.firstChildIndex + data.numberOfChildren - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            TrieNode node = new TrieNode(this.trie, i, this);
            char c = node.getChar();
            int compare = Character.compare(c, token);
            if (c < token) {
                min = i + 1;
                continue;
            }
            if (c > token) {
                max = i - 1;
                continue;
            }
            return Optional.of(node);
        }
        return Optional.empty();
    }

    protected void decrementCursorCount(long count) {
        this.trie.nodes.update(this.index, data -> data.setCursorCount(Math.max(data.cursorCount - count, 0L)));
        if (null != this.getParent()) {
            this.getParent().decrementCursorCount(count);
        }
    }

    public TrieNode traverse(String str) {
        if (str.isEmpty()) {
            return this;
        }
        return this.getChild(str.charAt(0)).map(n -> n.traverse(str.substring(1))).orElse(this);
    }

    public boolean containsCursor(long cursorId) {
        if (cursorId < this.getData().firstCursorIndex) {
            return false;
        }
        return cursorId < this.getData().firstCursorIndex + this.getData().cursorCount;
    }

    public TrieNode traverse(long cursorId) {
        if (!this.containsCursor(cursorId)) {
            throw new IllegalArgumentException();
        }
        return this.getChildren().filter(n -> n.containsCursor(cursorId)).findFirst().map(n -> n.traverse(cursorId)).orElse(this);
    }

    public void removeCursorCount() {
        this.decrementCursorCount(this.getCursorCount());
    }

    public Bits bitsTo(TrieNode toNode) {
        if (this.index == toNode.index) {
            return Bits.NULL;
        }
        return this.intervalTo(toNode).toBits();
    }

    public Interval intervalTo(TrieNode toNode) {
        return new Interval(toNode.getCursorIndex() - this.getCursorIndex(), toNode.getCursorCount(), this.getCursorCount());
    }

    public boolean hasChildren() {
        return 0 < this.getNumberOfChildren();
    }

    NodeData update(Function<NodeData, NodeData> update) {
        this.data = this.trie.nodes.update(this.index, update);
        return this.data;
    }

    public CharTrie getTrie() {
        return this.trie;
    }

    public boolean isStringTerminal() {
        if (this.getChar() == '\u0000') {
            return true;
        }
        if (this.getChar() == '\uffff' && null != this.getParent()) {
            return this.getParent().isStringTerminal();
        }
        return false;
    }

    public Stream<? extends TrieNode> streamDecendents(int level) {
        assert (level > 0);
        if (level == 1) {
            return this.getChildren();
        }
        return this.getChildren().flatMap(child -> child.streamDecendents(level - 1));
    }

    void writeChildren(TreeMap<Character, Long> counts) {
        int firstIndex = this.trie.nodes.length();
        counts.forEach((k, v) -> {
            if (v > 0L) {
                this.trie.nodes.add(new NodeData(k.charValue(), -1, -1, (long)v, -1L));
            }
        });
        short length = (short)(this.trie.nodes.length() - firstIndex);
        this.trie.ensureParentIndexCapacity(firstIndex, length, this.index);
        this.update(n -> n.setFirstChildIndex(firstIndex).setNumberOfChildren(length));
        this.data = null;
    }

    public TreeMap<Character, ? extends TrieNode> getChildrenMap() {
        TreeMap map = new TreeMap();
        this.getChildren().forEach(x -> map.put(Character.valueOf(x.getChar()), x));
        return map;
    }

    public Map<Character, TrieNode> getGodChildren() {
        String postContext = this.getString().substring(1);
        return this.trie.tokens().stream().collect(Collectors.toMap(x -> x, token -> {
            TrieNode traverse = this.trie.traverse(token + postContext);
            return traverse.getString().equals(token + postContext) ? traverse : null;
        })).entrySet().stream().filter(e -> null != e.getValue()).collect(Collectors.toMap(e -> (Character)e.getKey(), e -> (TrieNode)e.getValue()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrieNode trieNode = (TrieNode)o;
        if (this.getCursorCount() != ((TrieNode)o).getCursorCount()) {
            return false;
        }
        return this.getChildrenMap().equals(trieNode.getChildrenMap());
    }

    public int hashCode() {
        return this.getChildrenMap().hashCode() ^ Long.hashCode(this.getCursorCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrieNode getParent() {
        if (0 == this.index) {
            return null;
        }
        if (null == this.parent && -1 == this.depth) {
            TrieNode trieNode = this;
            synchronized (trieNode) {
                if (null == this.parent) {
                    this.parent = this.newNode(this.trie.parentIndex[this.index]);
                    assert (this.parent.index < this.index);
                }
            }
        }
        return this.parent;
    }

    public TrieNode getContinuation(char c) {
        return this.getChild(c).orElseGet(() -> {
            TrieNode godparent = this.godparent();
            if (null == godparent) {
                return null;
            }
            return godparent.getContinuation(c);
        });
    }
}

