/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import com.simiacryptus.util.data.ScalarStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class PercentileStatistics
extends ScalarStatistics {
    private final List<double[]> values = new ArrayList<double[]>();

    @Override
    @Nullable
    public synchronized ScalarStatistics add(double ... values) {
        if (null != this.values) {
            this.values.add(Arrays.copyOf(values, values.length));
        }
        super.add(values);
        return null;
    }

    @Override
    public void clear() {
        this.values.clear();
        super.clear();
    }

    @Override
    public Map<CharSequence, Object> getMetrics() {
        Map<CharSequence, Object> map = super.getMetrics();
        map.put("tp50", this.getPercentile(0.5));
        map.put("tp75", this.getPercentile(0.75));
        map.put("tp90", this.getPercentile(0.9));
        return map;
    }

    public synchronized Double getPercentile(double percentile) {
        if (null == this.values) {
            return Double.NaN;
        }
        return this.values.parallelStream().flatMapToDouble(x -> Arrays.stream(x)).sorted().skip((int)(percentile * (double)this.values.size())).findFirst().orElse(Double.NaN);
    }
}

