/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class StaticResourcePool<T> {
    @Nonnull
    private final List<T> all;
    private final LinkedBlockingQueue<T> pool = new LinkedBlockingQueue();

    public StaticResourcePool(@Nonnull List<T> items) {
        this.all = Collections.unmodifiableList(new ArrayList<T>(items));
        this.pool.addAll(this.getAll());
    }

    public void apply(@Nonnull Consumer<T> f) {
        this.apply(f, x -> true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(@Nonnull Consumer<T> f, Predicate<T> filter, boolean exclusive) {
        T poll = this.get(filter, exclusive);
        try {
            f.accept(poll);
        }
        finally {
            this.pool.add(poll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private T get(Predicate<T> filter, boolean exclusive) {
        T poll;
        ArrayList<T> sampled = new ArrayList<T>();
        try {
            poll = this.pool.poll();
            while (null != poll) {
                if (filter.test(poll)) {
                    T t = poll;
                    return t;
                }
                sampled.add(poll);
                poll = this.pool.poll();
            }
        }
        finally {
            this.pool.addAll(sampled);
        }
        try {
            while (true) {
                if (null == (poll = this.pool.poll(5L, TimeUnit.MINUTES))) {
                    throw new RuntimeException("Timeout awaiting item from pool");
                }
                if (!exclusive || filter.test(poll)) break;
                this.pool.add(poll);
                Thread.sleep(0L);
            }
            return poll;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<T> getAll() {
        return this.all;
    }

    public <U> U run(@Nonnull Function<T, U> f) {
        return this.run(f, x -> true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U run(@Nonnull Function<T, U> f, Predicate<T> filter, boolean exclusive) {
        if (this.all.isEmpty()) {
            throw new IllegalStateException();
        }
        T poll = this.get(filter, exclusive);
        try {
            U u = f.apply(poll);
            return u;
        }
        finally {
            this.pool.add(poll);
        }
    }

    public int size() {
        return this.getAll().size();
    }
}

