/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.lang.ReferenceCountingBase;
import com.simiacryptus.ref.wrappers.RefArrayList;
import com.simiacryptus.ref.wrappers.RefList;
import com.simiacryptus.ref.wrappers.RefMap;
import com.simiacryptus.ref.wrappers.RefMaps;
import com.simiacryptus.ref.wrappers.RefSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class CountCollection<T, C extends RefMap<T, AtomicInteger>>
extends ReferenceCountingBase {
    protected final @Nullable C map;

    public CountCollection(@Nullable C collection) {
        RefMap temp_00_0001 = (RefMap)RefUtil.addRef(collection);
        this.map = (RefMap)RefUtil.addRef((Object)temp_00_0001);
        if (null != temp_00_0001) {
            temp_00_0001.freeRef();
        }
        if (null != collection) {
            collection.freeRef();
        }
    }

    public @Nonnull RefList<T> getList() {
        RefArrayList list = new RefArrayList();
        assert (this.map != null);
        RefSet entries = this.map.entrySet();
        entries.forEach(e -> {
            for (int i = 0; i < ((AtomicInteger)e.getValue()).get(); ++i) {
                list.add(e.getKey());
            }
            RefUtil.freeRef((Object)e);
        });
        entries.freeRef();
        return list;
    }

    public @Nonnull RefMap<T, Integer> getMap() {
        return RefMaps.transformEntries((RefMap)((RefMap)RefUtil.addRef(this.map)), (RefMaps.EntryTransformer)new RefMaps.EntryTransformer<T, AtomicInteger, Integer>(){

            public Integer transformEntry(@RefAware T key, @RefAware @Nonnull AtomicInteger value) {
                RefUtil.freeRef(key);
                int i = value.get();
                RefUtil.freeRef((Object)value);
                return i;
            }
        });
    }

    public int add(T bits) {
        return this.getCounter(bits).incrementAndGet();
    }

    public int add(T bits, int count) {
        return this.getCounter(bits).addAndGet(count);
    }

    public void _free() {
        super._free();
        if (null != this.map) {
            this.map.freeRef();
        }
    }

    public @Nonnull CountCollection<T, C> addRef() {
        return (CountCollection)super.addRef();
    }

    protected int count(T key) {
        assert (this.map != null);
        AtomicInteger counter = (AtomicInteger)this.map.get(key);
        if (null == counter) {
            return 0;
        }
        return counter.get();
    }

    private @NotNull AtomicInteger getCounter(T bits) {
        assert (this.map != null);
        AtomicInteger counter = (AtomicInteger)this.map.get(bits);
        if (null == counter) {
            counter = new AtomicInteger();
            RefUtil.freeRef((Object)this.map.put(bits, (Object)counter));
        }
        return counter;
    }
}

