/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.util.JsonUtil;
import com.simiacryptus.util.Util;
import de.javakaffee.kryoserializers.KryoReflectionFactorySupport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public class IOUtil {
    private static final ObjectMapper objectMapper = JsonUtil.getMapper();
    private static final ThreadLocal<Kryo> kryo = new ThreadLocal<Kryo>(){

        @Override
        protected @Nonnull Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };
    private static final ThreadLocal<byte[]> buffer = new ThreadLocal<byte[]>(){

        @Override
        protected @Nonnull byte[] initialValue() {
            return new byte[0x800000];
        }
    };

    public static <T> void writeJson(T obj, @Nonnull File file) {
        StringWriter writer = new StringWriter();
        try {
            objectMapper.writeValue((Writer)writer, obj);
            Files.write(file.toPath(), writer.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }

    public static <T> T readJson(@Nonnull File file) {
        try {
            return (T)objectMapper.readValue(new String(Files.readAllBytes(file.toPath())), new TypeReference<T>(){});
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }

    public static <T> void writeKryo(T obj, @Nonnull OutputStream file) {
        try {
            Output output = new Output(buffer.get());
            new KryoReflectionFactorySupport().writeClassAndObject(output, obj);
            output.close();
            IOUtils.write((byte[])RefArrays.copyOf((byte[])output.getBuffer(), (int)output.position()), (OutputStream)file);
            file.close();
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }

    public static void writeString(@Nonnull String obj, @Nonnull OutputStream file) {
        try {
            IOUtils.write((byte[])obj.getBytes("UTF-8"), (OutputStream)file);
            file.close();
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }

    public static <T> @Nonnull T readKryo(@Nonnull File file) {
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            Input input = new Input(buffer.get(), 0, bytes.length);
            return (T)new KryoReflectionFactorySupport().readClassAndObject(input);
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }
}

