/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefIgnore;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefIntStream;
import com.simiacryptus.util.RefBeanSerializerFactory;
import com.simiacryptus.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    public static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);

    public static ObjectMapper getMapper() {
        ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setSerializerFactory((SerializerFactory)new RefBeanSerializerFactory());
        objectMapper.setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE));
        JsonUtil.registerDynamicModule(objectMapper, "com.fasterxml.jackson.module.scala.DefaultScalaModule");
        return objectMapper;
    }

    public static void registerDynamicModule(ObjectMapper objectMapper, String name) {
        try {
            objectMapper.registerModule((Module)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable e) {
            logger.debug(String.format("Cannot initialize jackson module %s: %s", name, e.getMessage()));
        }
    }

    public static double[] getDoubleArray(@Nonnull JsonArray array) {
        return RefIntStream.range((int)0, (int)array.size()).mapToDouble(i -> array.get(i).getAsDouble()).toArray();
    }

    public static @Nullable int[] getIntArray(@Nullable JsonArray array) {
        if (null == array) {
            return null;
        }
        return RefIntStream.range((int)0, (int)array.size()).map(i -> array.get(i).getAsInt()).toArray();
    }

    public static @Nonnull JsonArray getJson(@Nonnull double[] kernelDims) {
        @Nonnull JsonArray array = new JsonArray();
        for (double k : kernelDims) {
            array.add((JsonElement)new JsonPrimitive((Number)k));
        }
        return array;
    }

    public static @Nonnull JsonArray getJson(@Nonnull int[] kernelDims) {
        @Nonnull JsonArray array = new JsonArray();
        for (int k : kernelDims) {
            array.add((JsonElement)new JsonPrimitive((Number)k));
        }
        return array;
    }

    public static @Nonnull CharSequence toJson(@RefAware Object obj) {
        return JsonUtil.toJson(obj, JsonUtil.getMapper());
    }

    @RefIgnore
    public static @Nonnull CharSequence toJson(@RefAware Object obj, @Nonnull ObjectMapper objectMapper) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            objectMapper.writeValue((OutputStream)outputStream, obj);
            RefUtil.freeRef((Object)obj);
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
        return new String(outputStream.toByteArray(), Charset.forName("UTF-8"));
    }

    public static <T> T cache(@Nonnull File file, Class<T> clazz, @Nonnull Supplier<T> intializer) throws IOException {
        if (file.exists()) {
            return (T)JsonUtil.getMapper().readValue(FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()), clazz);
        }
        T obj = intializer.get();
        FileUtils.write((File)file, (CharSequence)JsonUtil.toJson(obj), (Charset)Charset.defaultCharset());
        return obj;
    }

    public static @Nonnull int[] toIntArray(@Nonnull JsonArray array) {
        int[] ints = new int[array.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = array.get(i).getAsInt();
        }
        return ints;
    }

    public static @Nonnull JsonArray toIntArray(@Nonnull int[] array) {
        JsonArray jsonElements = new JsonArray();
        RefArrays.stream((int[])array).forEach(number -> jsonElements.add((Number)number));
        return jsonElements;
    }

    public static JsonObject toJson(@Nonnull byte[] buf) {
        return (JsonObject)new GsonBuilder().create().fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(buf)), JsonObject.class);
    }
}

