/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefConcurrentHashMap;
import com.simiacryptus.ref.wrappers.RefConsumer;
import com.simiacryptus.ref.wrappers.RefIteratorBase;
import com.simiacryptus.ref.wrappers.RefSpliterators;
import com.simiacryptus.ref.wrappers.RefStream;
import com.simiacryptus.ref.wrappers.RefStreamSupport;
import com.simiacryptus.ref.wrappers.RefString;
import com.simiacryptus.ref.wrappers.RefSystem;
import com.simiacryptus.util.io.BinaryChunkIterator;
import com.simiacryptus.util.io.TeeInputStream;
import com.simiacryptus.util.test.LabeledObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Random;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final ThreadLocal<Random> R = new ThreadLocal<Random>(){
        public final Random r = new Random(RefSystem.nanoTime());

        @Override
        protected @Nonnull Random initialValue() {
            return new Random(this.r.nextLong());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(Util.class);
    private static final AtomicInteger idcounter = new AtomicInteger(0);
    private static final String jvmId = UUID.randomUUID().toString();

    public static CharSequence getCaller() {
        return Util.toString(Util.getStackTrace(4));
    }

    public static @Nonnull StackTraceElement[] getStackTrace() {
        return Util.getStackTrace(4);
    }

    public static void add(@Nonnull DoubleSupplier f, @Nonnull double[] data) {
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] + f.getAsDouble();
        }
    }

    public static RefStream<byte[]> binaryStream(String path, @Nonnull String name, int skip, int recordSize) throws IOException {
        @Nonnull File file = new File(path, name);
        byte[] fileData = IOUtils.toByteArray((InputStream)new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))));
        @Nonnull DataInputStream in = new DataInputStream(new ByteArrayInputStream(fileData));
        in.skip(skip);
        return Util.toIterator(new BinaryChunkIterator(in, recordSize));
    }

    public static <F, T> Function<F, T> cache(@Nonnull Function<F, T> inner) {
        RefConcurrentHashMap cache = new RefConcurrentHashMap();
        return (Function)RefUtil.wrapInterface(key -> cache.computeIfAbsent(key, inner::apply), (Object[])new Object[]{cache, inner});
    }

    public static @Nonnull InputStream cacheLocal(@Nonnull String file, @Nonnull URI url) throws IOException {
        return Util.cacheLocal(file, Util.getStreamSupplier(url));
    }

    public static @Nonnull InputStream cacheLocal(@Nonnull String file, @Nonnull Supplier<InputStream> fn) throws FileNotFoundException {
        File f = new File(file);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        FileOutputStream cache = new FileOutputStream(file);
        return new TeeInputStream(fn.get(), cache);
    }

    public static @Nonnull Supplier<InputStream> getStreamSupplier(@Nonnull URI url) {
        return () -> {
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public @Nonnull X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, trustManagers, null);
                SSLSocketFactory sslFactory = ctx.getSocketFactory();
                URLConnection urlConnection = url.toURL().openConnection();
                if (urlConnection instanceof HttpsURLConnection) {
                    HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
                    conn.setSSLSocketFactory(sslFactory);
                    conn.setRequestMethod("GET");
                }
                return urlConnection.getInputStream();
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                throw Util.throwException(e);
            }
        };
    }

    public static @Nonnull InputStream cacheStream(@Nonnull String url, @Nonnull String file) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        if (new File(file).exists()) {
            return new FileInputStream(file);
        }
        return new TeeInputStream(Util.get(url), new FileOutputStream(file));
    }

    public static @Nonnull File cacheFile(@Nonnull String url, @Nonnull String file) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        File fileLoc = new File(file).getCanonicalFile().getAbsoluteFile();
        if (!fileLoc.exists()) {
            log.info(RefString.format((String)"Downloading %s to %s", (Object[])new Object[]{url, fileLoc}));
            IOUtils.copy((InputStream)Util.get(url), (OutputStream)new FileOutputStream(fileLoc));
            log.info(RefString.format((String)"Finished Download of %s to %s", (Object[])new Object[]{url, fileLoc}));
        }
        return fileLoc;
    }

    public static InputStream get(@Nonnull String url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        @Nonnull TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public @Nonnull X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        @Nonnull SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, trustManagers, null);
        SSLSocketFactory sslFactory = ctx.getSocketFactory();
        URLConnection urlConnection = new URL(url).openConnection();
        if (urlConnection instanceof HttpsURLConnection) {
            @Nonnull HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
            conn.setSSLSocketFactory(sslFactory);
            conn.setRequestMethod("GET");
        }
        return urlConnection.getInputStream();
    }

    public static @Nonnull InputStream cacheStream(@Nonnull URI url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return Util.cacheStream(url.toString(), new File(url.getPath()).getName());
    }

    public static @Nonnull File cacheFile(@Nonnull URI url) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        return Util.cacheFile(url.toString(), new File(url.getPath()).getName());
    }

    public static @Nonnull CharSequence[] currentStack() {
        return (CharSequence[])Stream.of(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).toArray(CharSequence[]::new);
    }

    public static @Nonnull TemporalUnit cvt(@Nonnull TimeUnit units) {
        switch (units) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
        }
        throw new IllegalArgumentException(units.toString());
    }

    public static void layout(@Nonnull Component c) {
        c.doLayout();
        if (c instanceof Container) {
            RefArrays.stream((Object[])((Container)c).getComponents()).forEach(c1 -> Util.layout(c1));
        }
    }

    public static String mkString(@Nonnull CharSequence separator, CharSequence ... strs) {
        return Stream.of(strs).collect(Collectors.joining(separator));
    }

    public static @Nonnull String pathTo(@Nonnull File from, @Nonnull File to) {
        return from.toPath().relativize(to.toPath()).toString().replaceAll("\\\\", "/");
    }

    public static @Nonnull byte[] read(@Nonnull DataInputStream i, int s) throws IOException {
        int read;
        @Nonnull byte[] b = new byte[s];
        for (int pos = 0; b.length > pos; pos += read) {
            read = i.read(b, pos, b.length - pos);
            if (0 != read) continue;
            throw new RuntimeException();
        }
        return b;
    }

    public static @Nullable BufferedImage maximumSize(@Nullable BufferedImage image, int width) {
        if (null == image) {
            return null;
        }
        width = Math.min(image.getWidth(), width);
        if (width == image.getWidth()) {
            return image;
        }
        int height = image.getHeight() * width / image.getWidth();
        @Nonnull BufferedImage rerender = new BufferedImage(width, height, 2);
        Graphics gfx = rerender.getGraphics();
        @Nonnull RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        ((Graphics2D)gfx).setRenderingHints(hints);
        gfx.drawImage(image, 0, 0, rerender.getWidth(), rerender.getHeight(), null);
        return rerender;
    }

    public static @Nullable BufferedImage toImage(@Nullable Component component) {
        if (null == component) {
            return null;
        }
        try {
            Util.layout(component);
            @Nonnull BufferedImage img = new BufferedImage(component.getWidth(), component.getHeight(), 1);
            Graphics2D g = img.createGraphics();
            g.setColor(component.getForeground());
            g.setFont(component.getFont());
            component.print(g);
            return img;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static @Nonnull CharSequence toInlineImage(BufferedImage img, String alt) {
        return Util.toInlineImage(new LabeledObject<BufferedImage>(img, alt));
    }

    public static @Nonnull CharSequence toInlineImage(@Nonnull LabeledObject<BufferedImage> img) {
        @Nonnull ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img.data, "png", (OutputStream)b);
        }
        catch (Exception e) {
            RefUtil.freeRef(img);
            Util.throwException(e);
        }
        byte[] byteArray = b.toByteArray();
        String encode = Base64.getEncoder().encodeToString(byteArray);
        String s = "<img src=\"data:image/png;base64," + encode + "\" alt=\"" + img.label + "\" />";
        RefUtil.freeRef(img);
        return s;
    }

    public static <T> RefStream<T> toIterator(@Nonnull RefIteratorBase<T> iterator) {
        return RefStreamSupport.stream((Spliterator)RefSpliterators.spliterator(iterator, (int)1, (int)16), (boolean)false);
    }

    public static <T> RefStream<T> toStream(@Nonnull RefIteratorBase<T> iterator) {
        return Util.toStream(iterator, 0);
    }

    public static <T> RefStream<T> toStream(@RefAware @Nonnull RefIteratorBase<T> iterator, int size) {
        return Util.toStream(iterator, size, false);
    }

    public static <T> RefStream<T> toStream(@RefAware @Nonnull RefIteratorBase<T> iterator, int size, boolean parallel) {
        return RefStreamSupport.stream((Spliterator)RefSpliterators.spliterator(iterator, (int)size, (int)16), (boolean)parallel);
    }

    public static @Nonnull UUID uuid() {
        @Nonnull String index = Integer.toHexString(idcounter.incrementAndGet());
        while (index.length() < 8) {
            index = "0" + index;
        }
        @Nonnull String tempId = jvmId.substring(0, jvmId.length() - index.length()) + index;
        return UUID.fromString(tempId);
    }

    public static void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static @Nonnull String dateStr(@Nonnull String formatStr) {
        return new SimpleDateFormat(formatStr).format(new Date());
    }

    public static @Nonnull String stripPrefix(@Nonnull String str, @Nonnull String prefix) {
        while (str.startsWith(prefix)) {
            str = str.substring(prefix.length());
        }
        return str;
    }

    public static @Nonnull Path pathToFile(@Nonnull File baseFile, @Nonnull File file) {
        Path basePath = baseFile.toPath();
        Path path = file.toPath();
        return basePath.relativize(path);
    }

    public static @Nonnull String toString(@Nonnull Path path) {
        return path.normalize().toString().replaceAll("\\\\", "/");
    }

    public static void runAllParallel(Runnable ... runnables) {
        RefArrays.stream((Object[])runnables).parallel().forEach(runnable -> {
            try {
                runnable.run();
            }
            finally {
                RefUtil.freeRef((Object)runnable);
            }
        });
    }

    public static void runAllSerial(Runnable ... runnables) {
        RefArrays.stream((Object[])runnables).forEach(runnable -> {
            try {
                runnable.run();
            }
            finally {
                RefUtil.freeRef((Object)runnable);
            }
        });
    }

    public static @Nonnull String toString(@Nonnull RefConsumer<PrintStream> fn) {
        java.io.ByteArrayOutputStream buffer = new java.io.ByteArrayOutputStream();
        try (@Nonnull PrintStream out = new PrintStream(buffer);){
            fn.accept((Object)out);
        }
        return new String(buffer.toByteArray(), Charset.forName("UTF-8"));
    }

    public static String toString(@Nonnull StackTraceElement[] stack) {
        return Util.toString(stack, "\n");
    }

    public static String toString(@Nonnull StackTraceElement[] stack, CharSequence delimiter) {
        return Arrays.stream(stack).map(x -> x.getFileName() + ":" + x.getLineNumber()).reduce((a, b) -> a + delimiter + b).orElse("");
    }

    public static @Nonnull StackTraceElement[] getStackTrace(int skip) {
        return (StackTraceElement[])Arrays.stream(Thread.currentThread().getStackTrace()).skip(skip).filter(x -> x.getClassName().startsWith("com.simiacryptus.")).limit(500L).toArray(StackTraceElement[]::new);
    }

    public static @Nonnull float[] getFloats(@Nonnull double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    public static @Nonnull double[] getDoubles(@Nonnull float[] floats) {
        double[] doubles = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            doubles[i] = floats[i];
        }
        return doubles;
    }

    public static @Nonnull long[] toLong(@Nonnull int[] ints) {
        long[] longs = new long[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            longs[i] = ints[i];
        }
        return longs;
    }

    public static @Nonnull int[] toInt(@Nonnull long[] longs) {
        int[] ints = new int[longs.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (int)longs[i];
        }
        return ints;
    }

    public static String toString(@Nonnull Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream printStream = new PrintStream((OutputStream)out);){
            e.printStackTrace(printStream);
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw Util.throwException(e1);
        }
    }

    public static @NotNull URI getURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw Util.throwException(e);
        }
    }

    public static RuntimeException throwException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }
}

