/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary.codes;

import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefCollection;
import com.simiacryptus.ref.wrappers.RefTreeSet;
import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.Bits;
import com.simiacryptus.util.binary.bitset.BitsCollection;
import com.simiacryptus.util.binary.bitset.CountTreeBitsCollection;
import com.simiacryptus.util.binary.codes.HammingSymbol;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HammingCode<T extends Comparable<T>> {
    protected final TreeMap<Bits, T> forwardIndex = new TreeMap();
    protected final HashMap<T, Bits> reverseIndex = new HashMap();
    protected final HashMap<T, Integer> weights = new HashMap();
    protected final long totalWeight;

    public HammingCode(@Nonnull RefCollection<HammingSymbol<T>> symbols) {
        if (0 < symbols.size()) {
            RefTreeSet assemblySet = new RefTreeSet();
            symbols.forEach(symbol -> {
                this.weights.put(symbol.key, symbol.count);
                assemblySet.add(new SubCode(symbol.count, symbol.key));
            });
            while (assemblySet.size() > 1) {
                SubCode zero = (SubCode)assemblySet.pollFirst();
                SubCode one = (SubCode)assemblySet.pollFirst();
                assert (one != null);
                assert (zero != null);
                assemblySet.add(new SubCode(zero, one));
            }
            SubCode root = (SubCode)assemblySet.first();
            assemblySet.freeRef();
            this.forwardIndex.putAll(root.codes);
            this.reverseIndex.putAll(root.index);
            this.totalWeight = root.count;
        } else {
            this.totalWeight = 0L;
        }
        assert (this.verifyIndexes());
        assert (this.forwardIndex.size() == symbols.size());
        symbols.freeRef();
    }

    public @Nonnull CountTreeBitsCollection getSetEncoder() {
        return new HammingCodeCollection(this);
    }

    public @Nonnull Map<T, Integer> getWeights() {
        return Collections.unmodifiableMap(this.weights);
    }

    public static boolean isPrefixFreeCode(@Nonnull Set<Bits> keySet) {
        RefTreeSet check = new RefTreeSet();
        for (Bits code : keySet) {
            Bits ceiling = (Bits)check.ceiling((Object)code);
            if (null != ceiling && (ceiling.startsWith(code) || code.startsWith(ceiling))) {
                check.freeRef();
                return false;
            }
            Bits floor = (Bits)check.floor((Object)code);
            if (null != floor && (floor.startsWith(code) || code.startsWith(floor))) {
                check.freeRef();
                return false;
            }
            check.add((Object)code);
        }
        check.freeRef();
        return true;
    }

    public int codeSize() {
        return this.forwardIndex.size();
    }

    public T decode(@Nonnull BitInputStream in) throws IOException {
        Bits remainder = in.readAhead(0);
        Map.Entry<Bits, T> entry = this.forwardIndex.floorEntry(remainder);
        while (entry == null || !remainder.startsWith(entry.getKey())) {
            remainder = in.readAhead();
            if (null != entry) {
                RefUtil.freeRef(entry);
            }
            entry = this.forwardIndex.floorEntry(remainder);
        }
        in.read(entry.getKey().bitLength);
        Comparable temp_05_0001 = (Comparable)entry.getValue();
        RefUtil.freeRef(entry);
        return (T)temp_05_0001;
    }

    public @Nullable Map.Entry<Bits, T> decode(@Nullable Bits data) {
        if (null == data) {
            throw new IllegalArgumentException();
        }
        Map.Entry<Bits, T> entry = this.forwardIndex.floorEntry(data);
        if (entry != null && !data.startsWith(entry.getKey())) {
            RefUtil.freeRef(entry);
            return null;
        }
        return entry;
    }

    public Bits encode(T key) {
        Bits bits = this.reverseIndex.get(key);
        assert (null != bits || this.verifyIndexes());
        return bits;
    }

    public @Nonnull SortedMap<Bits, T> getCodes(@Nonnull Bits fromKey) {
        Bits next = fromKey.next();
        return null == next ? this.forwardIndex.tailMap(fromKey) : this.forwardIndex.subMap(fromKey, next);
    }

    public @Nonnull CountTreeBitsCollection getSetEncoder(@Nonnull BitInputStream data) throws IOException {
        return new HammingCodeCollection(data, this);
    }

    public @Nonnull CountTreeBitsCollection getSetEncoder(byte[] data) throws IOException {
        return new HammingCodeCollection(data, this);
    }

    public boolean verifyIndexes() {
        if (!HammingCode.isPrefixFreeCode(this.forwardIndex.keySet())) {
            return false;
        }
        for (Map.Entry<Bits, T> entry : this.forwardIndex.entrySet()) {
            if (!entry.getKey().equals(this.reverseIndex.get(entry.getValue()))) {
                return false;
            }
            if (((Comparable)entry.getValue()).equals(this.forwardIndex.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<Bits, Object> entry : this.reverseIndex.entrySet()) {
            if (!((Comparable)entry.getKey()).equals(this.forwardIndex.get(entry.getValue()))) {
                return false;
            }
            if (((Bits)entry.getValue()).equals(this.reverseIndex.get(entry.getKey()))) continue;
            return false;
        }
        return this.reverseIndex.size() == this.forwardIndex.size();
    }

    public int totalWeight() {
        return 0;
    }

    private static class SubCode<X extends Comparable<X>>
    implements Comparable<SubCode<X>> {
        final long count;
        final @Nonnull TreeMap<Bits, X> codes;
        final @Nonnull TreeMap<X, Bits> index;

        public SubCode(long count, X item) {
            this.count = count;
            this.codes = new TreeMap();
            this.index = new TreeMap();
            this.codes.put(Bits.NULL, item);
            this.index.put(item, Bits.NULL);
        }

        public SubCode(@Nonnull SubCode<X> zero, @Nonnull SubCode<X> one) {
            Bits code;
            this.count = zero.count + one.count;
            this.codes = new TreeMap();
            this.index = new TreeMap();
            for (Map.Entry<Bits, X> e : zero.codes.entrySet()) {
                assert (!one.index.containsKey(e.getValue()));
                code = Bits.ZERO.concatenate(e.getKey());
                this.assertNull(this.codes.put(code, e.getValue()));
                this.assertNull(this.index.put(e.getValue(), code));
            }
            for (Map.Entry<Bits, X> e : one.codes.entrySet()) {
                assert (!zero.index.containsKey(e.getValue()));
                code = Bits.ONE.concatenate(e.getKey());
                this.assertNull(this.codes.put(code, e.getValue()));
                this.assertNull(this.index.put(e.getValue(), code));
            }
        }

        @Override
        public int compareTo(@Nonnull SubCode<X> o) {
            if (this.count < o.count) {
                return -1;
            }
            if (this.count > o.count) {
                return 1;
            }
            int compareTo = ((Comparable)this.index.firstKey()).compareTo(o.index.firstKey());
            assert (0 != compareTo);
            return compareTo;
        }

        private void assertNull(@Nullable Object obj) {
            assert (null == obj);
        }
    }

    public static class HammingCodeCollection<T extends Comparable<T>>
    extends CountTreeBitsCollection {
        private final HammingCode<T> parent;

        public HammingCodeCollection(HammingCode<T> parent) {
            this.parent = parent;
        }

        public HammingCodeCollection(@Nonnull BitInputStream data, HammingCode<T> parent) throws IOException {
            super(data);
            this.parent = parent;
        }

        public HammingCodeCollection(byte[] data, HammingCode<T> parent) throws IOException {
            super(data);
            this.parent = parent;
        }

        @Override
        public  @Nonnull BitsCollection.CodeType getType(@Nonnull Bits bits) {
            Map.Entry<Bits, T> code = this.parent.decode(bits);
            if (null == code) {
                return BitsCollection.CodeType.Prefix;
            }
            assert (bits.equals(code.getKey()));
            RefUtil.freeRef(code);
            return BitsCollection.CodeType.Terminal;
        }

        @Override
        public void _free() {
            super._free();
        }

        @Override
        public @Nonnull HammingCodeCollection<T> addRef() {
            return (HammingCodeCollection)super.addRef();
        }
    }
}

