/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefString;
import java.util.DoubleSummaryStatistics;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class DoubleStatistics
extends DoubleSummaryStatistics {
    public static @Nonnull Collector<Double, DoubleStatistics, DoubleStatistics> COLLECTOR = Collector.of(() -> new DoubleStatistics(), (doubleStatistics, value) -> doubleStatistics.accept((double)value), (doubleStatistics, other) -> doubleStatistics.combine((DoubleStatistics)other), d -> d, new Collector.Characteristics[0]);
    public static @Nonnull Collector<Number, DoubleStatistics, DoubleStatistics> NUMBERS = Collector.of(() -> new DoubleStatistics(), (a, n) -> a.accept(n.doubleValue()), (doubleStatistics, other) -> doubleStatistics.combine((DoubleStatistics)other), d -> d, new Collector.Characteristics[0]);
    private double simpleSumOfSquare;
    private double sumOfSquare = 0.0;
    private double sumOfSquareCompensation;

    public final double getStandardDeviation() {
        return this.getCount() > 0L ? Math.sqrt(this.getSumOfSquare() / (double)this.getCount() - Math.pow(this.getAverage(), 2.0)) : 0.0;
    }

    public double getSumOfSquare() {
        double tmp = this.sumOfSquare + this.sumOfSquareCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSumOfSquare)) {
            return this.simpleSumOfSquare;
        }
        return tmp;
    }

    @Override
    public synchronized void accept(double value) {
        super.accept(value);
        double squareValue = value * value;
        this.simpleSumOfSquare += squareValue;
        this.sumOfSquareWithCompensation(squareValue);
    }

    public @Nonnull DoubleStatistics accept(@Nonnull double[] value) {
        RefArrays.stream((double[])value).forEach(value1 -> this.accept(value1));
        return this;
    }

    public @Nonnull DoubleStatistics combine(@Nonnull DoubleStatistics other) {
        super.combine(other);
        this.simpleSumOfSquare += other.simpleSumOfSquare;
        this.sumOfSquareWithCompensation(other.sumOfSquare);
        this.sumOfSquareWithCompensation(other.sumOfSquareCompensation);
        return this;
    }

    @Override
    public @Nonnull String toString() {
        return this.toString(1.0).toString();
    }

    public @Nonnull CharSequence toString(double scale) {
        return RefString.format((String)"%.4e +- %.4e [%.4e - %.4e] (%d#)", (Object[])new Object[]{this.getAverage() * scale, this.getStandardDeviation() * scale, this.getMin() * scale, this.getMax() * scale, this.getCount()});
    }

    private void sumOfSquareWithCompensation(double value) {
        double tmp = value - this.sumOfSquareCompensation;
        double velvel = this.sumOfSquare + tmp;
        this.sumOfSquareCompensation = velvel - this.sumOfSquare - tmp;
        this.sumOfSquare = velvel;
    }
}

