/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.ref.lang.ReferenceCountingBase;
import com.simiacryptus.ref.wrappers.RefArrayList;
import com.simiacryptus.ref.wrappers.RefCollections;
import com.simiacryptus.ref.wrappers.RefList;
import com.simiacryptus.ref.wrappers.RefSpliterators;
import com.simiacryptus.ref.wrappers.RefStream;
import com.simiacryptus.ref.wrappers.RefStreamSupport;
import com.simiacryptus.util.io.AsyncListIterator;
import java.util.Spliterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class DataLoader<T>
extends ReferenceCountingBase {
    private final RefList<T> queue = RefCollections.synchronizedList((RefList)new RefArrayList());
    private volatile @Nullable Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws InterruptedException {
        if (this.thread != null) {
            DataLoader dataLoader = this;
            synchronized (dataLoader) {
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.thread.join();
                    this.thread = null;
                    this.queue.clear();
                }
            }
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nonnull RefStream<T> stream() {
        if (this.thread == null) {
            DataLoader dataLoader = this;
            synchronized (dataLoader) {
                if (this.thread == null) {
                    this.thread = new Thread(() -> this.read(this.queue == null ? null : this.queue.addRef()));
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
            }
        }
        @Nullable AsyncListIterator<T> iterator = new AsyncListIterator(this.queue == null ? null : this.queue.addRef(), this.thread);
        return RefStreamSupport.stream((Spliterator)RefSpliterators.spliteratorUnknownSize(iterator, (int)1), (boolean)false).filter(x -> x != null);
    }

    public void _free() {
        super._free();
        if (null != this.queue) {
            this.queue.freeRef();
        }
    }

    public @Nonnull DataLoader<T> addRef() {
        return (DataLoader)super.addRef();
    }

    protected abstract void read(RefList<T> var1);
}

