/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractFile2DataSourceCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExcludeFilterEqualsHandler;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.CatalogNameProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.sql.Connection;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSynchronizeCommand
extends AbstractFile2DataSourceCommand<DbObjectDifference> {
    private EqualsHandler equalsHandler = new ExcludeFilterEqualsHandler(new String[]{SchemaProperties.CREATED_AT.getLabel(), SchemaProperties.LAST_ALTERED_AT.getLabel(), SchemaObjectProperties.ROWS.getLabel()});

    public EqualsHandler getEqualsHandler() {
        return this.equalsHandler;
    }

    public void setEqualsHandler(EqualsHandler equalsHandler) {
        this.equalsHandler = equalsHandler;
    }

    @Override
    protected List<DbObjectDifference> getTarget(List<DbCommonObject<?>> totalObjects, Connection connection, Dialect dialect) {
        List diffList = CommonUtils.list();
        for (DbCommonObject<?> object : totalObjects) {
            MetadataReader reader = MetadataReaderUtils.getMetadataReader((Dialect)dialect, (String)SchemaUtils.getSingularName((String)object.getClass().getSimpleName()));
            String catalogName = null;
            if (object instanceof CatalogNameProperty) {
                catalogName = ((CatalogNameProperty)object).getCatalogName();
            }
            SimpleBeanUtils.setValueCI((Object)reader, (String)SchemaProperties.CATALOG_NAME.getLabel(), (Object)catalogName);
            if (object instanceof DbObject) {
                DbObjectDifference diff = this.getDiff((DbObject)object, reader, connection);
                diffList.add(diff);
                continue;
            }
            List<DbObjectDifference> ret = this.getDiff((DbObjectCollection)object, reader, connection);
            diffList.addAll(ret);
        }
        return diffList;
    }

    protected List<DbObjectDifference> getDiff(DbObjectCollection<?> objects, MetadataReader<?, ?> reader, Connection connection) {
        List diffList = CommonUtils.list();
        for (DbObject obj : objects) {
            DbObjectDifference diff = this.getDiff(obj, reader, connection);
            diffList.add(diff);
        }
        return diffList;
    }

    protected DbObjectDifference getDiff(DbObject obj, MetadataReader reader, Connection connection) {
        if (obj instanceof SchemaNameProperty) {
            SimpleBeanUtils.setValue((Object)reader, (String)SchemaProperties.SCHEMA_NAME.getLabel(), (Object)((SchemaNameProperty)obj).getSchemaName());
        }
        List originals = reader.getAllFull(connection);
        DbObject original = (DbObject)CommonUtils.first((List)originals);
        DbObjectDifference diff = original.diff(obj, this.getEqualsHandler());
        return diff;
    }

    @Override
    protected void handle(DbObjectDifference diff, SqlFactoryRegistry sqlFactoryRegistry, Connection connection, Dialect dialect) throws Exception {
        SqlFactory sqlFactory = sqlFactoryRegistry.getSqlFactory(diff, SqlType.ALTER);
        Options sqlOptions = sqlFactory.getOptions().clone();
        sqlFactory.setOptions(sqlOptions);
        List sqlTexts = sqlFactory.createDiffSql(diff);
        this.getSqlExecutor().execute((Collection)sqlTexts);
    }
}

