/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.schemas.AssemblyFile;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.util.List;

public enum HighlightMethod {
    Highlight{

        @Override
        public boolean isHighlight() {
            return true;
        }

        @Override
        public String getVersion() {
            return "9.12.0";
        }

        @Override
        public String getCommonPath() {
            return "//cdnjs.cloudflare.com/ajax/libs/highlight.js/";
        }

        @Override
        public String[] getJsInternal() {
            return new String[]{"/highlight.min.js"};
        }

        @Override
        protected String[] getCssInternal() {
            return new String[]{"/styles/github.min.css"};
        }

        @Override
        protected String getLanguageInternal(String text) {
            if (text.equalsIgnoreCase("cs")) {
                return "cs";
            }
            return super.getLanguageInternal(text);
        }

        @Override
        public String loadInitScript() {
            return "hljs.initHighlightingOnLoad();";
        }
    }
    ,
    Prism{

        @Override
        public boolean isPrism() {
            return true;
        }

        @Override
        public String getVersion() {
            return "1.11.0";
        }

        @Override
        public String getCommonPath() {
            return "//cdnjs.cloudflare.com/ajax/libs/prism/";
        }

        @Override
        public String[] getJsInternal() {
            return new String[]{"/prism.min.js", "/components/prism-css-extras.min.js", "/components/prism-csharp.min.js", "/components/prism-java.min.js", "/components/prism-sql.min.js"};
        }

        @Override
        protected String[] getCssInternal() {
            return new String[]{"/themes/prism.min.css"};
        }

        @Override
        protected String getLanguageInternal(String text) {
            if (text.equalsIgnoreCase("cs")) {
                return "csharp";
            }
            return super.getLanguageInternal(text);
        }

        @Override
        public String getLanguagePefix() {
            return "language-";
        }

        @Override
        protected String getPreClassInternal() {
            return "line-numbers";
        }
    };


    public String getCommonPath() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public String[] getJs() {
        String[] args = new String[this.getJsInternal().length];
        for (int i = 0; i < this.getJsInternal().length; ++i) {
            args[i] = this.getCommonPath() + this.getVersion() + this.getJsInternal()[i];
        }
        return args;
    }

    protected String[] getJsInternal() {
        return new String[0];
    }

    public String[] getCss() {
        String[] args = new String[this.getCssInternal().length];
        for (int i = 0; i < this.getCssInternal().length; ++i) {
            args[i] = this.getCommonPath() + this.getVersion() + this.getCssInternal()[i];
        }
        return args;
    }

    protected String[] getCssInternal() {
        return new String[0];
    }

    public String getLanguagePefix() {
        return "";
    }

    public boolean isHighlight() {
        return false;
    }

    public boolean isPrism() {
        return false;
    }

    public String getLanguage(Object obj) {
        return this.getLanguagePefix() + this.getLanguageInternal(obj);
    }

    protected String getLanguageInternal(Object obj) {
        if (obj instanceof AssemblyFile) {
            AssemblyFile assemblyFile = (AssemblyFile)obj;
            String extension = FileUtils.getExtension((String)assemblyFile.getName());
            return this.getLanguageInternal(extension);
        }
        if (obj instanceof List) {
            List args = (List)obj;
            if (args.size() == 0) {
                return "sql";
            }
            String first = (String)CommonUtils.first((List)args);
            if (first.startsWith("<")) {
                return "xml";
            }
        }
        return "sql";
    }

    protected String getLanguageInternal(String text) {
        if (text.equalsIgnoreCase("cs")) {
            return "csharp";
        }
        if (text.equalsIgnoreCase("vb")) {
            return "vb";
        }
        if (text.equalsIgnoreCase("xml")) {
            return "xml";
        }
        return "sql";
    }

    public String getPreClass() {
        if (this.getPreClassInternal() != null) {
            return "class=\"" + this.getPreClassInternal() + "\"";
        }
        return null;
    }

    protected String getPreClassInternal() {
        return null;
    }

    public String loadInitScript() {
        return "";
    }
}

