/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.ConvertHandler;
import com.sqlapp.data.db.command.SimpleConvertHandler;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ExceptionHandler;
import com.sqlapp.util.JsonConverter;
import com.sqlapp.util.ToRuntimeExceptionHandler;
import com.sqlapp.util.YamlConverter;
import java.io.PrintStream;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCommand
implements Runnable {
    protected static final Logger logger = LogManager.getLogger(AbstractCommand.class);
    private ExceptionHandler exceptionHandler = new ToRuntimeExceptionHandler();
    private ConvertHandler convertHandler = new SimpleConvertHandler();
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private Map<String, Object> context = CommonUtils.linkedMap();
    private Converters converters = Converters.getDefault();

    protected JsonConverter createJsonConverter() {
        JsonConverter jsonConverter = new JsonConverter();
        jsonConverter.setIndentOutput(true);
        return jsonConverter;
    }

    protected YamlConverter createYamlConverter() {
        YamlConverter jsonConverter = new YamlConverter();
        jsonConverter.setIndentOutput(true);
        return jsonConverter;
    }

    @Override
    public void run() {
        this.initialize();
        this.doRun();
    }

    protected void initialize() {
        this.initializeContext();
    }

    protected void initializeContext() {
        this.context.putAll(System.getenv());
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.context.put(this.converters.convertString(k), this.converters.convertString(v))));
    }

    protected abstract void doRun();

    private PrintStream getOut() {
        return this.out;
    }

    protected void println(Object obj) {
        if (obj != null) {
            this.getOut().println(obj.toString());
        }
    }

    protected PrintStream getErr() {
        return this.err;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ConvertHandler getConvertHandler() {
        return this.convertHandler;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setConvertHandler(ConvertHandler convertHandler) {
        this.convertHandler = convertHandler;
    }
}

