/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.command.properties.OnlyCurrentCatalogProperty;
import com.sqlapp.data.db.command.properties.OnlyCurrentSchemaProperty;
import com.sqlapp.data.db.command.properties.OutputDirectoryProperty;
import com.sqlapp.data.db.command.properties.SchemaOptionProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.metadata.ObjectNameReaderPredicate;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.RowIteratorHandlerProperty;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.TableNameRowCollectionFilter;
import com.sqlapp.data.schemas.rowiterator.JdbcDynamicRowIteratorHandler;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import lombok.Generated;

public class ExportXmlCommand
extends AbstractSchemaDataSourceCommand
implements SchemaOptionProperty,
OnlyCurrentCatalogProperty,
OnlyCurrentSchemaProperty,
OutputDirectoryProperty {
    private String target = "catalog";
    private File outputDirectory;
    private boolean dumpRows = true;
    private String[] includeRowDumpTables = null;
    private String[] excludeRowDumpTables = null;
    private String[] includeSchemas = null;
    private String[] excludeSchemas = null;
    private String[] includeObjects = null;
    private String[] excludeObjects = null;
    private String outputFileName;
    private boolean onlyCurrentCatalog = true;
    private boolean onlyCurrentSchema = false;
    private Consumer<DbObject<?>> converter = c -> {};
    private Options schemaOptions = new Options();

    @Override
    protected void doRun() {
        Dialect[] dialect = new Dialect[1];
        List[] list = new List[1];
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            dialect[0] = this.getDialect((Connection)connection);
            MetadataReader reader = this.getMetadataReader((Connection)connection, dialect[0]);
            RowIteratorHandler rowIteratorHandler = null;
            if (this.isDumpRows()) {
                rowIteratorHandler = this.getRowIteratorHandler();
            }
            ReadDbObjectPredicate readerFilter = this.getMetadataReaderFilter();
            reader.setReadDbObjectPredicate(readerFilter);
            list[0] = this.readDbMetadataReader((Connection)connection, (MetadataReader)reader);
            for (DbObject object : list[0]) {
                if (!(object instanceof RowIteratorHandlerProperty)) continue;
                ((RowIteratorHandlerProperty)object).setRowIteratorHandler(rowIteratorHandler);
            }
            list[0] = this.getConvertHandler().handle(list[0]);
            for (DbObject object : list[0]) {
                object.applyAll(this.converter);
            }
        }));
        String rootElementName = SchemaUtils.getPluralName((String)this.getTarget());
        FileUtils.createParentDirectory((String)this.getOutputFileFullPath());
        this.execute(() -> {
            try (FileOutputStream fos = new FileOutputStream(this.getOutputFileFullPath());
                 BufferedOutputStream bos = new BufferedOutputStream(fos);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF-8");){
                StaxWriter staxWriter = new StaxWriter((Writer)writer);
                if (this.getTarget().endsWith("s")) {
                    staxWriter.writeStartElement(rootElementName);
                    staxWriter.addIndentLevel(1);
                }
                SchemaUtils.writeAllXml((List)list[0], (StaxWriter)staxWriter);
                if (this.getTarget().endsWith("s")) {
                    staxWriter.addIndentLevel(-1);
                    staxWriter.newLine();
                    staxWriter.indent();
                    staxWriter.writeEndElement();
                }
            }
        });
    }

    protected MetadataReader getMetadataReader(Connection connection, Dialect dialect) throws SQLException {
        MetadataReader reader = MetadataReaderUtils.getMetadataReader((Dialect)dialect, (String)this.getTarget());
        String catalogName = this.getCurrentCatalogName(connection);
        String schemaName = this.getCurrentSchemaName(connection);
        if (this.isOnlyCurrentCatalog()) {
            SimpleBeanUtils.setValue((Object)reader, (String)"catalogName", (Object)catalogName);
        }
        if (this.isOnlyCurrentSchema()) {
            SimpleBeanUtils.setValue((Object)reader, (String)"schemaName", (Object)schemaName);
        }
        return reader;
    }

    private <T extends DbObject<? super T>> List<T> readDbMetadataReader(Connection connection, MetadataReader<T, ?> dbMetadataReader) {
        return dbMetadataReader.getAllFull(connection);
    }

    protected RowIteratorHandler getRowIteratorHandler() {
        JdbcDynamicRowIteratorHandler rowIteratorHandler = new JdbcDynamicRowIteratorHandler();
        rowIteratorHandler.setDataSource(this.getDataSource());
        rowIteratorHandler.setOptions(this.getSchemaOptions());
        TableNameRowCollectionFilter filter = new TableNameRowCollectionFilter();
        filter.setIncludes(this.getIncludeRowDumpTables());
        filter.setExcludes(this.getExcludeRowDumpTables());
        rowIteratorHandler.setFilter((Predicate)filter);
        return rowIteratorHandler;
    }

    protected ReadDbObjectPredicate getMetadataReaderFilter() {
        ObjectNameReaderPredicate readerFilter = new ObjectNameReaderPredicate(this.getIncludeSchemas(), this.getExcludeSchemas(), this.getIncludeObjects(), this.getExcludeObjects());
        return readerFilter;
    }

    public void setIncludeRowDumpTables(String ... includeRowDumpTables) {
        this.includeRowDumpTables = includeRowDumpTables;
    }

    public void setExcludeRowDumpTables(String ... excludeRowDumpTables) {
        this.excludeRowDumpTables = excludeRowDumpTables;
    }

    public void setIncludeSchemas(String ... includeSchemas) {
        this.includeSchemas = includeSchemas;
    }

    public void setExcludeSchemas(String ... excludeSchemas) {
        this.excludeSchemas = excludeSchemas;
    }

    public void setIncludeObjects(String ... includeObjects) {
        this.includeObjects = includeObjects;
    }

    public void setExcludeObjects(String ... excludeObjects) {
        this.excludeObjects = excludeObjects;
    }

    public String getOutputFileName() {
        if (this.outputFileName == null) {
            this.outputFileName = StringUtils.capitalize((String)this.target) + ".xml";
        }
        return this.outputFileName;
    }

    public String getOutputFileFullPath() {
        return FileUtils.combinePath((Object[])new Object[]{this.getOutputDirectory(), CommonUtils.coalesce((Object)this.getOutputFileName(), (Object)"dump.xml")});
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Override
    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public boolean isDumpRows() {
        return this.dumpRows;
    }

    @Generated
    public String[] getIncludeRowDumpTables() {
        return this.includeRowDumpTables;
    }

    @Generated
    public String[] getExcludeRowDumpTables() {
        return this.excludeRowDumpTables;
    }

    @Generated
    public String[] getIncludeSchemas() {
        return this.includeSchemas;
    }

    @Generated
    public String[] getExcludeSchemas() {
        return this.excludeSchemas;
    }

    @Generated
    public String[] getIncludeObjects() {
        return this.includeObjects;
    }

    @Generated
    public String[] getExcludeObjects() {
        return this.excludeObjects;
    }

    @Override
    @Generated
    public boolean isOnlyCurrentCatalog() {
        return this.onlyCurrentCatalog;
    }

    @Override
    @Generated
    public boolean isOnlyCurrentSchema() {
        return this.onlyCurrentSchema;
    }

    @Generated
    public Consumer<DbObject<?>> getConverter() {
        return this.converter;
    }

    @Override
    @Generated
    public Options getSchemaOptions() {
        return this.schemaOptions;
    }

    @Generated
    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    @Generated
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Generated
    public void setDumpRows(boolean dumpRows) {
        this.dumpRows = dumpRows;
    }

    @Generated
    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Override
    @Generated
    public void setOnlyCurrentCatalog(boolean onlyCurrentCatalog) {
        this.onlyCurrentCatalog = onlyCurrentCatalog;
    }

    @Override
    @Generated
    public void setOnlyCurrentSchema(boolean onlyCurrentSchema) {
        this.onlyCurrentSchema = onlyCurrentSchema;
    }

    @Generated
    public void setConverter(Consumer<DbObject<?>> converter) {
        this.converter = converter;
    }

    @Override
    @Generated
    public void setSchemaOptions(Options schemaOptions) {
        this.schemaOptions = schemaOptions;
    }
}

