/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.factory;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.function.ColumnFunction;

public class ColumnMaxValue
implements ColumnFunction<String> {
    private static final long serialVersionUID = -2049712084354162318L;

    public String apply(Column column) {
        if (column.getDataType() == DataType.BOOLEAN) {
            return this.calculateBooleanMaxValue(column);
        }
        if (column.getDataType() == DataType.NUMERIC || column.getDataType() == DataType.DECIMAL) {
            return "" + this.calculateDecimalMaxValue(column);
        }
        if (column.getDataType().isNumeric()) {
            return this.calculateNumericMaxValue(column);
        }
        if (column.getDataType() == DataType.TIMESTAMP || column.getDataType() == DataType.DATETIME) {
            return this.calculateDateTimeMaxValue(column);
        }
        if (column.getDataType() == DataType.TIME) {
            return this.calculateTimeMaxValue(column);
        }
        if (column.getDataType() == DataType.DATE) {
            return this.calculateDateMaxValue(column);
        }
        return this.calculateOtherMaxValue(column);
    }

    protected String calculateOtherMaxValue(Column column) {
        return null;
    }

    protected String calculateBooleanMaxValue(Column column) {
        return null;
    }

    protected String calculateTimeMaxValue(Column column) {
        return null;
    }

    protected String calculateDateTimeMaxValue(Column column) {
        return "addMonths(_min." + column.getName() + ",1)";
    }

    protected String calculateDateMaxValue(Column column) {
        return "addMonths(_min." + column.getName() + ",1)";
    }

    protected long calculateDecimalMaxValue(Column column) {
        long len;
        Long length = column.getLength();
        Integer scale = column.getScale();
        if (length != null) {
            len = scale == null ? length : length - (long)scale.intValue();
        } else {
            return (long)Math.pow(10.0, 8.0);
        }
        return (long)Math.pow(10.0, len);
    }

    protected String calculateNumericMaxValue(Column column) {
        if (column.getDataType().getMaxValue() != null) {
            return "" + column.getDataType().getMaxValue();
        }
        return null;
    }
}

