/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.command.properties.OnlyCurrentCatalogProperty;
import com.sqlapp.data.db.command.properties.OnlyCurrentSchemaProperty;
import com.sqlapp.data.db.command.properties.SchemaTargetProperty;
import com.sqlapp.data.db.command.properties.TableOptionProperty;
import com.sqlapp.data.db.command.properties.TableTargetProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ObjectNameReaderPredicate;
import com.sqlapp.data.db.metadata.ReadDbObjectPredicate;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public abstract class AbstractTableCommand
extends AbstractSchemaDataSourceCommand
implements SchemaTargetProperty,
TableTargetProperty,
OnlyCurrentCatalogProperty,
OnlyCurrentSchemaProperty,
TableOptionProperty {
    private String[] includeSchemas = null;
    private String[] excludeSchemas = null;
    private String[] includeTables = null;
    private String[] excludeTables = null;
    private boolean onlyCurrentCatalog = true;
    private boolean onlyCurrentSchema = false;
    private TableOptions tableOptions = new TableOptions();

    protected SchemaReader getSchemaReader(Connection connection, Dialect dialect) throws SQLException {
        CatalogReader catalogReader = dialect.getCatalogReader();
        SchemaReader schemaReader = catalogReader.getSchemaReader();
        if (this.isOnlyCurrentCatalog()) {
            String catalogName = this.getCurrentCatalogName(connection);
            schemaReader.setCatalogName(catalogName);
        }
        if (this.isOnlyCurrentSchema()) {
            String schemaName = this.getCurrentSchemaName(connection);
            schemaReader.setSchemaName(schemaName);
        }
        schemaReader.setReadDbObjectPredicate(this.getMetadataReaderFilter());
        return schemaReader;
    }

    protected List<Table> getTables(Connection connection, Dialect dialect) throws SQLException {
        Catalog catalog = new Catalog();
        catalog.setDialect(dialect);
        Map<String, Schema> schemaMap = this.getSchemaMap(connection, dialect);
        schemaMap.forEach((k, v) -> catalog.getSchemas().add((AbstractNamedObject)v));
        List tables = CommonUtils.list();
        for (Schema schema : catalog.getSchemas()) {
            for (Table table : schema.getTables()) {
                tables.add(table);
            }
        }
        return tables;
    }

    private Map<String, Schema> getSchemaMap(Connection connection, Dialect dialect) throws SQLException {
        SchemaReader schemaReader = this.getSchemaReader(connection, dialect);
        Map<String, Schema> schemaMap = this.getSchemas(connection, dialect, schemaReader, s -> true);
        return schemaMap;
    }

    protected ReadDbObjectPredicate getMetadataReaderFilter() {
        ObjectNameReaderPredicate readerFilter = new ObjectNameReaderPredicate(this.getIncludeSchemas(), this.getExcludeSchemas(), this.getIncludeTables(), this.getExcludeTables());
        return readerFilter;
    }

    @Override
    public void setIncludeSchemas(String ... includeSchemas) {
        this.includeSchemas = includeSchemas;
    }

    @Override
    public void setExcludeSchemas(String ... excludeSchemas) {
        this.excludeSchemas = excludeSchemas;
    }

    @Override
    public void setIncludeTables(String ... includeTables) {
        this.includeTables = includeTables;
    }

    @Override
    public void setExcludeTables(String ... excludeTables) {
        this.excludeTables = excludeTables;
    }

    @Override
    @Generated
    public String[] getIncludeSchemas() {
        return this.includeSchemas;
    }

    @Override
    @Generated
    public String[] getExcludeSchemas() {
        return this.excludeSchemas;
    }

    @Override
    @Generated
    public String[] getIncludeTables() {
        return this.includeTables;
    }

    @Override
    @Generated
    public String[] getExcludeTables() {
        return this.excludeTables;
    }

    @Override
    @Generated
    public boolean isOnlyCurrentCatalog() {
        return this.onlyCurrentCatalog;
    }

    @Override
    @Generated
    public boolean isOnlyCurrentSchema() {
        return this.onlyCurrentSchema;
    }

    @Override
    @Generated
    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    @Override
    @Generated
    public void setOnlyCurrentCatalog(boolean onlyCurrentCatalog) {
        this.onlyCurrentCatalog = onlyCurrentCatalog;
    }

    @Override
    @Generated
    public void setOnlyCurrentSchema(boolean onlyCurrentSchema) {
        this.onlyCurrentSchema = onlyCurrentSchema;
    }

    @Override
    @Generated
    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }
}

