/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.db.command.export.AbstractExportCommand;
import com.sqlapp.data.db.command.export.TableFileReader;
import com.sqlapp.data.db.command.properties.DirectoryProperty;
import com.sqlapp.data.db.command.properties.FileDirectoryProperty;
import com.sqlapp.data.db.command.properties.FilesProperty;
import com.sqlapp.data.db.command.properties.PlaceholderProperty;
import com.sqlapp.data.db.command.properties.QueryCommitIntervalProperty;
import com.sqlapp.data.db.command.properties.SqlTypeProperty;
import com.sqlapp.data.db.command.properties.TableOptionProperty;
import com.sqlapp.data.db.command.properties.UseTableNameDirectoryProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.CombinedRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.CsvRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.ExcelRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.JsonRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.data.schemas.rowiterator.XmlRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.YamlRowIteratorHandler;
import com.sqlapp.exceptions.InvalidValueException;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.jdbc.sql.GeneratedKeyInfo;
import com.sqlapp.jdbc.sql.JdbcBatchIterateHander;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import lombok.Generated;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class ImportDataFromFileCommand
extends AbstractExportCommand
implements PlaceholderProperty,
TableOptionProperty,
SqlTypeProperty,
FileDirectoryProperty,
FilesProperty,
QueryCommitIntervalProperty,
DirectoryProperty,
UseTableNameDirectoryProperty {
    private boolean useTableNameDirectory = false;
    private long queryCommitInterval = Long.MAX_VALUE;
    private File directory = new File(".");
    private File fileDirectory = null;
    private File[] files = null;
    private SqlType sqlType = SqlType.MERGE_ROW;
    private Predicate<File> fileFilter = f -> true;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean placeholders = false;
    private int csvSkipHeaderRowsSize = 1;
    private int excelSkipHeaderRowsSize = 1;
    private RowValueConverter rowValueConverter;

    @Override
    protected void doRun() {
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            File[] directories;
            Dialect dialect = this.getDialect((Connection)connection);
            SchemaReader schemaReader = this.getSchemaReader((Connection)connection, dialect);
            Set schemaNames = CommonUtils.lowerSet();
            if (this.isUseSchemaNameDirectory() && (directories = this.getDirectory().listFiles(c -> c.isDirectory())) != null) {
                for (File directory : directories) {
                    String name = directory.getName();
                    schemaNames.add(name);
                }
            }
            TableFileReader tableFileReader = this.createTableFileReader();
            Map<String, Schema> schemaMap = this.isUseSchemaNameDirectory() ? this.getSchemas((Connection)connection, dialect, schemaReader, s -> schemaNames.contains(s.getName())) : this.getSchemas((Connection)connection, dialect, schemaReader, s -> true);
            Catalog catalog = new Catalog();
            catalog.setDialect(dialect);
            schemaMap.forEach((k, v) -> catalog.getSchemas().add((AbstractNamedObject)v));
            List<TableFileReader.TableFilesPair> tfs = tableFileReader.getTableFilePairs(catalog);
            this.execute(() -> tableFileReader.setFiles(tfs));
            if (this.getSqlType().getTableComparator() != null) {
                List sorted = SchemaUtils.getNewSortedTableList(tfs, (Comparator)this.getSqlType().getTableComparator(), tf -> tf.getTable());
                tfs.clear();
                tfs.addAll(sorted);
            }
            connection.setAutoCommit(false);
            int commitCount = 0;
            for (TableFileReader.TableFilesPair tf2 : tfs) {
                this.info((Object)("target=" + tf2));
                if (this.getTableOptions().getCommitPerTable().test((Object)tf2.getTable())) {
                    this.executeImport((Connection)connection, dialect, tf2.getTable(), tf2.getFiles());
                    this.commit((Connection)connection);
                    ++commitCount;
                    continue;
                }
                this.executeImport((Connection)connection, dialect, tf2.getTable(), tf2.getFiles());
            }
            if (commitCount == 0) {
                this.commit((Connection)connection);
            }
        }));
    }

    private TableFileReader createTableFileReader() {
        TableFileReader tableFileReader = new TableFileReader();
        tableFileReader.setContext(this.getContext());
        tableFileReader.setCsvEncoding(this.getCsvEncoding());
        tableFileReader.setDirectory(this.getDirectory());
        tableFileReader.setFileDirectory(this.getFileDirectory());
        tableFileReader.setFileFilter(this.getFileFilter());
        tableFileReader.setFiles(this.getFiles());
        tableFileReader.setJsonConverter(this.getJsonConverter());
        tableFileReader.setPlaceholderPrefix(this.getPlaceholderPrefix());
        tableFileReader.setPlaceholders(this.isPlaceholders());
        tableFileReader.setPlaceholderSuffix(this.getPlaceholderSuffix());
        tableFileReader.setUseSchemaNameDirectory(this.isUseSchemaNameDirectory());
        tableFileReader.setUseTableNameDirectory(this.isUseTableNameDirectory());
        return tableFileReader;
    }

    protected void executeImport(Connection connection, Dialect dialect, Table table, List<File> files) throws SQLException, EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        if (this.getSqlType().supportRows()) {
            this.applyFromFileByRow(connection, dialect, table, files);
        } else {
            this.applyFromFileByTable(connection, dialect, table, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFromFileByRow(Connection connection, Dialect dialect, Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException, SQLException {
        SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
        sqlFactoryRegistry.getOption().setTableOptions(this.getTableOptions());
        SqlFactory factory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)new Row(), this.getSqlType());
        long queryCount = 0L;
        List targets = CommonUtils.list();
        if (!CommonUtils.isEmpty(files)) {
            for (File file : files) {
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    if (listFiles == null) continue;
                    for (File children : listFiles) {
                        targets.add(children);
                    }
                    continue;
                }
                targets.add(file);
            }
            this.readFiles(table, targets);
        }
        SqlConverter sqlConverter = this.getSqlConverter();
        int batchSize = (Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table);
        List batchRows = CommonUtils.list((int)batchSize);
        try {
            for (Row row : table.getRows()) {
                batchRows.add(row);
                if (batchRows.size() < batchSize) continue;
                List operations = factory.createSql((Collection)batchRows);
                ParametersContext context = new ParametersContext();
                context.putAll(this.getContext());
                context.putAll(this.convert(sqlConverter, row, table.getColumns()));
                for (SqlOperation operation : operations) {
                    SqlNode sqlNode = sqlConverter.parseSql(context, operation.getSqlText());
                    JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                    jdbcHandler.execute(connection, context);
                    queryCount = this.commit(connection, queryCount);
                }
                batchRows.clear();
            }
        }
        finally {
            table.setRowIteratorHandler(null);
        }
        if (batchRows.size() > 0) {
            List operations = factory.createSql((Collection)batchRows);
            ParametersContext context = new ParametersContext();
            context.putAll(this.getContext());
            for (SqlOperation operation : operations) {
                SqlNode sqlNode = sqlConverter.parseSql(context, operation.getSqlText());
                JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                jdbcHandler.execute(connection, context);
                this.commit(connection);
            }
            batchRows.clear();
        }
    }

    protected SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        sqlConverter.getExpressionConverter().setFileDirectory(this.getFileDirectory());
        sqlConverter.getExpressionConverter().setPlaceholderPrefix(this.getPlaceholderPrefix());
        sqlConverter.getExpressionConverter().setPlaceholderSuffix(this.getPlaceholderSuffix());
        sqlConverter.getExpressionConverter().setPlaceholders(this.isPlaceholders());
        return sqlConverter;
    }

    private long commit(Connection connection, long queryCount) throws SQLException {
        if (queryCount + 1L >= this.getQueryCommitInterval()) {
            this.commit(connection);
            return 0L;
        }
        return queryCount + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFromFileByTable(Connection connection, Dialect dialect, Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException, SQLException {
        SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
        SqlFactory factory = sqlFactoryRegistry.getSqlFactory((DbCommonObject)table, this.getSqlType());
        List operations = factory.createSql((DbCommonObject)table);
        SqlConverter sqlConverter = this.getSqlConverter();
        List sqlNodes = operations.stream().map(c -> {
            ParametersContext context = new ParametersContext();
            context.putAll(this.getContext());
            SqlNode sqlNode = sqlConverter.parseSql(context, c.getSqlText());
            return sqlNode;
        }).collect(Collectors.toList());
        List targets = CommonUtils.list();
        if (!CommonUtils.isEmpty(files)) {
            for (File file : files) {
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    if (listFiles == null) continue;
                    for (File children : listFiles) {
                        targets.add(children);
                    }
                    continue;
                }
                targets.add(file);
            }
            this.readFiles(table, targets);
        }
        try {
            JdbcBatchIterateHander handler = new JdbcBatchIterateHander(sqlNodes, ((Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table)).intValue(), this.getQueryCommitInterval());
            handler.setValueConverter(r -> {
                ParametersContext context = new ParametersContext();
                context.putAll(this.getContext());
                context.putAll(this.convert(sqlConverter, (Row)r, table.getColumns()));
                return context;
            });
            handler.setBatchUpdateResultHandler(result -> {
                int max = result.getGeneratedKeys().size();
                for (int i = 0; i < max; ++i) {
                    GeneratedKeyInfo gk = (GeneratedKeyInfo)result.getGeneratedKeys().get(i);
                    Row row = (Row)((JdbcBatchIterateHander.ValueHolder)result.getValues().get(i)).value();
                    Column column = (Column)table.getColumns().get(gk.getColumnName());
                    row.put(column, gk.getValue());
                }
            });
            handler.execute(connection, (Iterable)table.getRows());
        }
        finally {
            table.setRowIteratorHandler(null);
        }
    }

    private Map<String, Object> convert(SqlConverter sqlConverter, Row row, ColumnCollection columns) {
        Map map = row.toMap();
        Map ret = CommonUtils.map((int)map.size());
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        for (Column column : columns) {
            Object val;
            Object originalValue = row.get(column);
            try {
                val = sqlConverter.getExpressionConverter().convert(originalValue, (Object)context);
            }
            catch (IOException e) {
                throw new InvalidValueException(row.getDataSourceInfo(), row.getDataSourceDetailInfo(), column.getName(), originalValue, (Throwable)e);
            }
            ret.put(column.getName(), val);
        }
        return ret;
    }

    private RowValueConverter createRowValueConverter() {
        SqlConverter sqlConverter = this.getSqlConverter();
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        return (RowValueConverter & Serializable)(r, c, v) -> {
            Object val;
            if (this.getSqlType().supportRows()) {
                return v;
            }
            Object originalVal = this.getRowValueConverter() != null ? this.getRowValueConverter().apply(r, c, v) : v;
            try {
                val = sqlConverter.getExpressionConverter().convert(originalVal, (Object)context);
            }
            catch (IOException e) {
                throw new InvalidValueException(r, c, v, (Throwable)e);
            }
            return val;
        };
    }

    private void readFiles(Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        if (files.size() == 1) {
            table.setRowIteratorHandler(this.createRowIteratorHandler((File)CommonUtils.first(files)));
        } else {
            List handlers = files.stream().map(file -> this.createRowIteratorHandler((File)file)).collect(Collectors.toList());
            table.setRowIteratorHandler((RowIteratorHandler)new CombinedRowIteratorHandler(handlers));
        }
    }

    private RowIteratorHandler createRowIteratorHandler(File file) {
        WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
        if (workbookFileType.isTextFile()) {
            if (workbookFileType.isCsv()) {
                return new CsvRowIteratorHandler(file, this.getCsvEncoding(), this.getCsvSkipHeaderRowsSize(), this.createRowValueConverter());
            }
            if (workbookFileType.isXml()) {
                return new XmlRowIteratorHandler(file, this.createRowValueConverter());
            }
            if (workbookFileType.isYaml()) {
                return new YamlRowIteratorHandler(file, this.getYamlConverter(), this.createRowValueConverter());
            }
            return new JsonRowIteratorHandler(file, this.getJsonConverter(), this.createRowValueConverter());
        }
        return new ExcelRowIteratorHandler(file, this.getExcelSkipHeaderRowsSize(), this.createRowValueConverter());
    }

    protected void readFileAsXml(Table table, File file, WorkbookFileType workbookFileType) throws XMLStreamException, FileNotFoundException {
        XmlReaderOptions options = new XmlReaderOptions();
        options.setRowValueConverter(this.createRowValueConverter());
        table.loadXml(file, options);
    }

    @Override
    public void setFiles(File ... obj) {
        this.files = obj;
    }

    @Override
    @Generated
    public boolean isUseTableNameDirectory() {
        return this.useTableNameDirectory;
    }

    @Override
    @Generated
    public long getQueryCommitInterval() {
        return this.queryCommitInterval;
    }

    @Override
    @Generated
    public File getDirectory() {
        return this.directory;
    }

    @Override
    @Generated
    public File getFileDirectory() {
        return this.fileDirectory;
    }

    @Override
    @Generated
    public File[] getFiles() {
        return this.files;
    }

    @Override
    @Generated
    public SqlType getSqlType() {
        return this.sqlType;
    }

    @Generated
    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    @Override
    @Generated
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    @Generated
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    @Generated
    public boolean isPlaceholders() {
        return this.placeholders;
    }

    @Generated
    public int getCsvSkipHeaderRowsSize() {
        return this.csvSkipHeaderRowsSize;
    }

    @Generated
    public int getExcelSkipHeaderRowsSize() {
        return this.excelSkipHeaderRowsSize;
    }

    @Generated
    public RowValueConverter getRowValueConverter() {
        return this.rowValueConverter;
    }

    @Override
    @Generated
    public void setUseTableNameDirectory(boolean useTableNameDirectory) {
        this.useTableNameDirectory = useTableNameDirectory;
    }

    @Override
    @Generated
    public void setQueryCommitInterval(long queryCommitInterval) {
        this.queryCommitInterval = queryCommitInterval;
    }

    @Override
    @Generated
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    @Override
    @Generated
    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    @Override
    @Generated
    public void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    @Generated
    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    @Generated
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    @Override
    @Generated
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    @Generated
    public void setPlaceholders(boolean placeholders) {
        this.placeholders = placeholders;
    }

    @Generated
    public void setCsvSkipHeaderRowsSize(int csvSkipHeaderRowsSize) {
        this.csvSkipHeaderRowsSize = csvSkipHeaderRowsSize;
    }

    @Generated
    public void setExcelSkipHeaderRowsSize(int excelSkipHeaderRowsSize) {
        this.excelSkipHeaderRowsSize = excelSkipHeaderRowsSize;
    }

    @Generated
    public void setRowValueConverter(RowValueConverter rowValueConverter) {
        this.rowValueConverter = rowValueConverter;
    }
}

